/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator;

import com.cmeza.sdgenerator.annotation.SDGenerator;
import com.cmeza.sdgenerator.support.ManagerTemplateSupport;
import com.cmeza.sdgenerator.support.RepositoryTemplateSupport;
import com.cmeza.sdgenerator.support.ScanningConfigurationSupport;
import com.cmeza.sdgenerator.util.GeneratorUtils;
import com.cmeza.sdgenerator.util.SDLogger;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public class SDGeneratorManager
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
ResourceLoaderAware {
    private Environment environment;
    private ResourceLoader resourceLoader;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)beanDefinitionRegistry, (String)"BeanDefinitionRegistry must not be null!");
        if (annotationMetadata.getAnnotationAttributes(SDGenerator.class.getName()) != null) {
            AnnotationAttributes attributes = new AnnotationAttributes(annotationMetadata.getAnnotationAttributes(SDGenerator.class.getName()));
            String repositoryPackage = attributes.getString("repositoryPackage");
            String managerPackage = attributes.getString("managerPackage");
            boolean lombokAnnotations = attributes.getBoolean("lombokAnnotations");
            boolean withComments = attributes.getBoolean("withComments");
            boolean withJpaSpecificationExecutor = attributes.getBoolean("withJpaSpecificationExecutor");
            if (!managerPackage.isEmpty() && repositoryPackage.isEmpty()) {
                SDLogger.error("Repositories must be generated before generating managers");
                return;
            }
            if (!repositoryPackage.isEmpty() || !managerPackage.isEmpty()) {
                ScanningConfigurationSupport configurationSource = new ScanningConfigurationSupport(annotationMetadata, attributes, this.environment);
                Collection<BeanDefinition> candidates = configurationSource.getCandidates(this.resourceLoader);
                String absolutePath = GeneratorUtils.getAbsolutePath();
                if (absolutePath == null) {
                    SDLogger.addError("Could not define the absolute path!");
                    return;
                }
                if (!repositoryPackage.isEmpty()) {
                    String repositoriesPath = absolutePath + repositoryPackage.replace(".", "/");
                    Set<String> additionalExtends = this.validateExtends(attributes.getClassArray("additionalExtends"));
                    if (Objects.nonNull(additionalExtends)) {
                        RepositoryTemplateSupport repositoryTemplateSupport = new RepositoryTemplateSupport(attributes, additionalExtends, withComments, withJpaSpecificationExecutor);
                        repositoryTemplateSupport.initializeCreation(repositoriesPath, repositoryPackage, candidates, (String[])Iterables.toArray(configurationSource.getBasePackages(), String.class));
                    }
                }
                if (!repositoryPackage.isEmpty() && !managerPackage.isEmpty()) {
                    String managerPath = absolutePath + managerPackage.replace(".", "/");
                    String repositoryPostfix = attributes.getString("repositoryPostfix");
                    ManagerTemplateSupport managerTemplateSupport = new ManagerTemplateSupport(attributes, repositoryPackage, repositoryPostfix, lombokAnnotations, withComments);
                    managerTemplateSupport.initializeCreation(managerPath, managerPackage, candidates, (String[])Iterables.toArray(configurationSource.getBasePackages(), String.class));
                }
                SDLogger.printGeneratedTables(attributes.getBoolean("debug"));
            }
        }
    }

    private Set<String> validateExtends(Class<?>[] additionalExtends) {
        boolean errorValidate = Boolean.FALSE;
        LinkedHashSet<String> additionalExtendsList = new LinkedHashSet<String>();
        for (Class<?> extendTemporal : additionalExtends) {
            SDLogger.addAdditionalExtend(extendTemporal.getName());
            if (!extendTemporal.isInterface()) {
                SDLogger.addError(String.format("'%s' is not a interface!", extendTemporal.getName()));
                errorValidate = Boolean.TRUE;
                continue;
            }
            additionalExtendsList.add(extendTemporal.getName());
        }
        if (errorValidate) {
            return null;
        }
        return additionalExtendsList;
    }
}

