/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.plugin;

import com.cmeza.sdgenerator.util.GeneratorProperties;
import com.cmeza.sdgenerator.util.SDLogger;
import com.cmeza.sdgenerator.util.SDMojoException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class CommonsMojo
extends AbstractMojo {
    @Parameter(name="entity-package")
    protected String[] entityPackage;
    @Parameter(name="repository-package")
    protected String repositoryPackage;
    @Parameter(name="repository-postfix", defaultValue="Repository")
    protected String repositoryPostfix;
    @Parameter(name="manager-package")
    protected String managerPackage;
    @Parameter(name="manager-postfix", defaultValue="Manager")
    protected String managerPostfix;
    @Parameter(name="only-annotations", defaultValue="false")
    protected Boolean onlyAnnotations;
    @Parameter(name="overwrite", defaultValue="false")
    protected Boolean overwrite;
    @Parameter(name="lombok-annotations", defaultValue="false")
    protected Boolean lombokAnnotations;
    @Parameter(name="with-comments", defaultValue="true")
    protected Boolean withComments;
    @Parameter(name="with-JpaSpecificationExecutor", defaultValue="true")
    protected Boolean withJpaSpecificationExecutor;
    @Parameter(name="additional-extends")
    protected String[] additionalExtends;
    @Component
    protected MavenProject project;
    protected Set<String> additionalExtendsList = new LinkedHashSet<String>();

    public void validateField(String parameter) throws SDMojoException {
        boolean errorFound = Boolean.FALSE;
        switch (parameter) {
            case "entity-package": {
                if (this.entityPackage != null) break;
                errorFound = Boolean.TRUE;
                break;
            }
            case "repository-package": {
                if (this.repositoryPackage != null) break;
                errorFound = Boolean.TRUE;
                break;
            }
            case "repository-postfix": {
                if (this.repositoryPostfix != null) break;
                errorFound = Boolean.TRUE;
                break;
            }
            case "manager-package": {
                if (this.managerPackage != null) break;
                errorFound = Boolean.TRUE;
                break;
            }
            case "manager-postfix": {
                if (this.managerPostfix != null) break;
                errorFound = Boolean.TRUE;
                break;
            }
            case "additional-extends": {
                if (this.additionalExtends == null) break;
                this.validateExtends();
                break;
            }
            default: {
                SDLogger.addError(String.format("%s configuration parameter not found!", parameter));
                throw new SDMojoException();
            }
        }
        if (errorFound) {
            SDLogger.addError(String.format("%s configuration not found!", parameter));
            throw new SDMojoException();
        }
    }

    private void validateExtends() throws SDMojoException {
        boolean errorValidate = Boolean.FALSE;
        for (int i = 0; i < this.additionalExtends.length; ++i) {
            String extendTemporal = this.additionalExtends[i];
            SDLogger.addAdditionalExtend(extendTemporal);
            if (extendTemporal.contains(".")) {
                this.additionalExtendsList.add(extendTemporal);
                continue;
            }
            errorValidate = Boolean.TRUE;
            SDLogger.addError(String.format("'%s' is not a valid object!", extendTemporal));
        }
        if (errorValidate) {
            throw new SDMojoException();
        }
    }

    protected GeneratorProperties buildProperties() {
        return GeneratorProperties.builder().entityPackage(this.entityPackage).repositoryPackage(this.repositoryPackage).repositoryPostfix(this.repositoryPostfix).managerPackage(this.managerPackage).managerPostfix(this.managerPostfix).onlyAnnotations(this.onlyAnnotations).overwrite(this.overwrite).lombokAnnotations(this.lombokAnnotations).withComments(this.withComments).withJpaSpecificationExecutor(this.withJpaSpecificationExecutor).additionalExtendsList(this.additionalExtendsList).project(this.project).build();
    }
}

