/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.plugin;

import com.cmeza.sdgenerator.plugin.CommonsMojo;
import com.cmeza.sdgenerator.support.ManagerTemplateSupport;
import com.cmeza.sdgenerator.support.ScanningConfigurationSupport;
import com.cmeza.sdgenerator.util.CustomResourceLoader;
import com.cmeza.sdgenerator.util.GeneratorProperties;
import com.cmeza.sdgenerator.util.GeneratorUtils;
import com.cmeza.sdgenerator.util.SDLogger;
import com.cmeza.sdgenerator.util.SDMojoException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="managers")
@Execute(phase=LifecyclePhase.COMPILE)
public class SDManagerMojo
extends CommonsMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        SDLogger.configure(this.getLog());
        this.validateField("entity-package");
        this.validateField("manager-package");
        this.validateField("repository-package");
        try {
            GeneratorProperties generatorProperties = this.buildProperties();
            this.executeInternalMojo(generatorProperties);
            SDLogger.printGeneratedTables(true);
        }
        catch (Exception e) {
            SDLogger.addError(e.getMessage());
            throw new SDMojoException(e.getMessage(), e);
        }
    }

    public void executeInternalMojo(GeneratorProperties generatorProperties) throws MojoExecutionException {
        CustomResourceLoader resourceLoader = new CustomResourceLoader(generatorProperties.getProject());
        resourceLoader.setPostfix(generatorProperties.getManagerPostfix());
        resourceLoader.setRepositoryPackage(generatorProperties.getRepositoryPackage());
        resourceLoader.setRepositoryPostfix(generatorProperties.getRepositoryPostfix());
        resourceLoader.setOverwrite(generatorProperties.isOverwrite());
        String absolutePath = GeneratorUtils.getAbsolutePath(generatorProperties.getManagerPackage());
        if (absolutePath == null) {
            SDLogger.addError("Could not define the absolute path of the managers");
            throw new SDMojoException();
        }
        ScanningConfigurationSupport scanningConfigurationSupport = new ScanningConfigurationSupport(generatorProperties.getEntityPackage(), generatorProperties.isOnlyAnnotations());
        ManagerTemplateSupport managerTemplateSupport = new ManagerTemplateSupport(resourceLoader, generatorProperties.isLombokAnnotations(), generatorProperties.isWithComments());
        managerTemplateSupport.initializeCreation(absolutePath, generatorProperties.getManagerPackage(), scanningConfigurationSupport.getCandidates(resourceLoader), generatorProperties.getEntityPackage());
    }
}

