/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.plugin;

import com.cmeza.sdgenerator.plugin.CommonsMojo;
import com.cmeza.sdgenerator.support.RepositoryTemplateSupport;
import com.cmeza.sdgenerator.support.ScanningConfigurationSupport;
import com.cmeza.sdgenerator.util.CustomResourceLoader;
import com.cmeza.sdgenerator.util.GeneratorProperties;
import com.cmeza.sdgenerator.util.GeneratorUtils;
import com.cmeza.sdgenerator.util.SDLogger;
import com.cmeza.sdgenerator.util.SDMojoException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="repositories")
@Execute(phase=LifecyclePhase.COMPILE)
public class SDRepositoryMojo
extends CommonsMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        SDLogger.configure(this.getLog());
        this.validateField("entity-package");
        this.validateField("repository-package");
        this.validateField("manager-package");
        this.validateField("additional-extends");
        try {
            GeneratorProperties generatorProperties = this.buildProperties();
            this.executeInternalMojo(generatorProperties);
            SDLogger.printGeneratedTables(true);
        }
        catch (Exception e) {
            SDLogger.addError(e.getMessage());
            throw new SDMojoException(e.getMessage(), e);
        }
    }

    public void executeInternalMojo(GeneratorProperties generatorProperties) throws MojoExecutionException {
        CustomResourceLoader resourceLoader = new CustomResourceLoader(generatorProperties.getProject());
        resourceLoader.setPostfix(generatorProperties.getRepositoryPostfix());
        resourceLoader.setOverwrite(generatorProperties.isOverwrite());
        String absolutePath = GeneratorUtils.getAbsolutePath(generatorProperties.getRepositoryPackage());
        if (absolutePath == null) {
            SDLogger.addError("Could not define the absolute path of the repositories");
            throw new SDMojoException();
        }
        ScanningConfigurationSupport scanningConfigurationSupport = new ScanningConfigurationSupport(generatorProperties.getEntityPackage(), generatorProperties.isOnlyAnnotations());
        RepositoryTemplateSupport repositoryTemplateSupport = new RepositoryTemplateSupport(resourceLoader, generatorProperties.getAdditionalExtendsList(), generatorProperties.isWithComments(), generatorProperties.isWithJpaSpecificationExecutor());
        repositoryTemplateSupport.initializeCreation(absolutePath, generatorProperties.getRepositoryPackage(), scanningConfigurationSupport.getCandidates(resourceLoader), generatorProperties.getEntityPackage());
    }
}

