/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.provider;

import com.cmeza.sdgenerator.util.CustomResourceLoader;
import com.cmeza.sdgenerator.util.GeneratorUtils;
import com.cmeza.sdgenerator.util.SDLogger;
import com.cmeza.sdgenerator.util.Tuple;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.Assert;

public abstract class AbstractTemplateProvider {
    private final Class<?>[] excludeClasses;
    private final String postfix;
    private final boolean debug;
    private Collection<File> includeFilter;
    private String includeFilterPostfix = "";
    private final boolean overwrite;

    protected AbstractTemplateProvider(AnnotationAttributes attributes) {
        Assert.notNull((Object)attributes, (String)"AnnotationAttributes must not be null!");
        this.excludeClasses = attributes.getClassArray(this.getExcludeClasses());
        this.postfix = attributes.getString(this.getPostfix());
        this.debug = attributes.getBoolean("debug");
        this.overwrite = attributes.getBoolean("overwrite");
        if (this.excludeClasses.length > 0 && this.debug) {
            SDLogger.debug(String.format("Exclude %s %s in the %s generator", this.excludeClasses.length, this.excludeClasses.length == 1 ? "entity" : "entities", this.postfix));
        }
    }

    protected AbstractTemplateProvider(CustomResourceLoader customResourceLoader) {
        Assert.notNull((Object)customResourceLoader, (String)"CustomResourceLoader must not be null!");
        this.postfix = customResourceLoader.getPostfix();
        this.debug = true;
        this.excludeClasses = new Class[0];
        this.overwrite = customResourceLoader.isOverwrite();
    }

    public void initializeCreation(String path, String ePackage, Collection<BeanDefinition> candidates, String[] entityPackage) {
        int generatedCount = 0;
        if (!GeneratorUtils.verifyPackage(path)) {
            return;
        }
        Arrays.sort(entityPackage, Comparator.comparingInt(String::length));
        for (BeanDefinition beanDefinition : candidates) {
            if (this.verifyEntityNonExclude(beanDefinition.getBeanClassName()) || !this.createHelper(path, beanDefinition, this.postfix, ePackage, entityPackage)) continue;
            ++generatedCount;
        }
        SDLogger.plusGenerated(generatedCount);
    }

    protected void setIncludeFilter(Collection<File> includeFilter) {
        this.includeFilter = includeFilter;
    }

    protected void setIncludeFilterPostfix(String includeFilterPostfix) {
        this.includeFilterPostfix = includeFilterPostfix;
    }

    private Tuple<Boolean, Integer> verifyIncludeFilter(String beanDefinitionName) {
        int warnPosition = 0;
        if (this.includeFilter == null) {
            return new Tuple<Boolean, Integer>(Boolean.TRUE, warnPosition);
        }
        boolean result = this.includeFilter.stream().anyMatch(i -> i.getName().replace(".java", "").equals(beanDefinitionName + this.includeFilterPostfix));
        if (!result) {
            warnPosition = SDLogger.addWarn(String.format("%s ignored: Repository not found for %s entity class", this.postfix, beanDefinitionName));
        }
        return new Tuple<Boolean, Integer>(result, warnPosition);
    }

    private boolean verifyEntityNonExclude(String beanClassName) {
        return Arrays.stream(this.excludeClasses).anyMatch(b -> b.getName().equals(beanClassName));
    }

    private boolean createHelper(String path, BeanDefinition beanDefinition, String postfix, String repositoryPackage, String[] entityPackage) {
        Assert.notNull((Object)beanDefinition, (String)"BeanDefinition is null");
        String simpleClassName = GeneratorUtils.getSimpleClassName(beanDefinition.getBeanClassName());
        Tuple<Boolean, Integer> result = null;
        if (simpleClassName != null) {
            String fileHelper = simpleClassName + postfix + ".java";
            Object additionalPath = this.getAdditionalPath(entityPackage, beanDefinition, simpleClassName, path);
            String additionalPackage = "";
            if (!StringUtils.isEmpty((CharSequence)additionalPath)) {
                repositoryPackage = (String)repositoryPackage + "." + (String)additionalPath;
                additionalPackage = additionalPath;
                additionalPath = ((String)additionalPath).replace(".", File.separator) + File.separator;
            }
            String filePath = path + File.separator + (String)additionalPath + fileHelper;
            Tuple<Boolean, Integer> verifyInclude = this.verifyIncludeFilter(simpleClassName);
            if (!verifyInclude.left().booleanValue()) {
                SDLogger.addRowGeneratedTable(postfix, fileHelper, "Warn #" + verifyInclude.right());
                return false;
            }
            File file = new File(filePath);
            String fileCondition = "Created";
            if (this.overwrite && file.exists()) {
                GeneratorUtils.deleteQuietly(file);
                fileCondition = "Overwritten";
            }
            if (!file.exists()) {
                result = this.createFileFromTemplate(filePath, (String)repositoryPackage, simpleClassName, postfix, beanDefinition, additionalPackage);
                if (this.debug) {
                    SDLogger.addRowGeneratedTable(postfix, fileHelper, result.left() != false ? fileCondition : "Error #" + result.right());
                }
            }
        } else {
            SDLogger.addError(String.format("Could not get SimpleName from: %s", beanDefinition.getBeanClassName()));
        }
        return result != null && (Boolean)result.left() != false;
    }

    protected abstract Tuple<String, Integer> getContentFromTemplate(String var1, String var2, String var3, BeanDefinition var4, String var5);

    private Tuple<Boolean, Integer> createFileFromTemplate(String path, String repositoryPackage, String simpleClassName, String postfix, BeanDefinition beanDefinition, String additionalPackage) {
        Tuple<Boolean, Integer> tuple;
        Tuple<String, Integer> content = this.getContentFromTemplate(repositoryPackage, simpleClassName, postfix, beanDefinition, additionalPackage);
        if (content.left() == null) {
            return new Tuple<Boolean, Integer>(false, content.right());
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(path));
        try {
            bw.write(content.left());
            tuple = new Tuple<Boolean, Integer>(true, 0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return new Tuple<Boolean, Integer>(false, SDLogger.addError("Error occurred while persisting file: " + e.getMessage()));
            }
        }
        bw.close();
        return tuple;
    }

    protected abstract String getExcludeClasses();

    protected abstract String getPostfix();

    private String getAdditionalPath(String[] entityPackages, BeanDefinition beanDefinition, String filename, String path) {
        ArrayList<String> additionalFolders = new ArrayList<String>();
        for (String entityPackage : entityPackages) {
            String stack;
            if (!beanDefinition.getBeanClassName().startsWith(entityPackage) || (stack = beanDefinition.getBeanClassName().replace(entityPackage, "").replace(filename, "")).length() <= 1) continue;
            if (stack.startsWith(".")) {
                stack = stack.substring(1);
            }
            if (stack.endsWith(".")) {
                stack = stack.substring(0, stack.length() - 1);
            }
            additionalFolders.add(stack);
        }
        if (!additionalFolders.isEmpty()) {
            additionalFolders.sort((a, b) -> Integer.compare(b.length(), a.length()));
            String additional = path + "/" + (String)additionalFolders.get(0);
            String pathAdditional = additional.replace(".", "/");
            GeneratorUtils.verifyPackage(pathAdditional);
            return (String)additionalFolders.get(0);
        }
        return "";
    }
}

