/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.provider;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathScanningProvider
extends ClassPathScanningCandidateComponentProvider {
    private Class<?> classComparator;

    public ClassPathScanningProvider() {
        super(false);
    }

    public void setIncludeAnnotation(Class<? extends Annotation> annotation) {
        this.classComparator = annotation;
        super.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
    }

    public void setExcludeAnnotation(Class<? extends Annotation> annotation) {
        super.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        if (this.classComparator == null) {
            return false;
        }
        boolean isNonRepositoryInterface = !this.classComparator.getName().equals(beanDefinition.getBeanClassName());
        boolean isTopLevelType = !beanDefinition.getMetadata().hasEnclosingClass();
        return isNonRepositoryInterface && isTopLevelType;
    }
}

