/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.support;

import com.cmeza.sdgenerator.provider.AbstractTemplateProvider;
import com.cmeza.sdgenerator.support.maker.ManagerStructure;
import com.cmeza.sdgenerator.util.CustomResourceLoader;
import com.cmeza.sdgenerator.util.GeneratorUtils;
import com.cmeza.sdgenerator.util.Tuple;
import java.io.File;
import java.util.Arrays;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;

public class ManagerTemplateSupport
extends AbstractTemplateProvider {
    private final String repositoryPackage;
    private final String repositoryPostfix;
    private final boolean lombokAnnotations;
    private final boolean withComments;

    public ManagerTemplateSupport(AnnotationAttributes attributes, String repositoryPackage, String repositoryPostfix, boolean lombokAnnotations, boolean withComments) {
        super(attributes);
        this.repositoryPackage = repositoryPackage;
        this.repositoryPostfix = repositoryPostfix;
        this.lombokAnnotations = lombokAnnotations;
        this.withComments = withComments;
        this.findFilterRepositories();
    }

    public ManagerTemplateSupport(CustomResourceLoader customResourceLoader, boolean lombokAnnotations, boolean withComments) {
        super(customResourceLoader);
        this.repositoryPackage = customResourceLoader.getRepositoryPackage();
        this.repositoryPostfix = customResourceLoader.getRepositoryPostfix();
        this.lombokAnnotations = lombokAnnotations;
        this.withComments = withComments;
        this.findFilterRepositories();
    }

    private void findFilterRepositories() {
        String repositoryPath = GeneratorUtils.getAbsolutePath() + this.repositoryPackage.replace(".", "/");
        File[] repositoryFiles = GeneratorUtils.getFileList(repositoryPath, this.repositoryPostfix);
        this.setIncludeFilter(Arrays.asList(repositoryFiles));
        this.setIncludeFilterPostfix(this.repositoryPostfix);
    }

    @Override
    protected Tuple<String, Integer> getContentFromTemplate(String mPackage, String simpleClassName, String postfix, BeanDefinition beanDefinition, String additionalPackage) {
        return new ManagerStructure(mPackage, simpleClassName, beanDefinition.getBeanClassName(), postfix, this.repositoryPackage, this.repositoryPostfix, additionalPackage, this.lombokAnnotations, this.withComments).build();
    }

    @Override
    protected String getExcludeClasses() {
        return "excludeManagerClasses";
    }

    @Override
    protected String getPostfix() {
        return "managerPostfix";
    }
}

