/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.support;

import com.cmeza.sdgenerator.annotation.SDGenerate;
import com.cmeza.sdgenerator.annotation.SDNoGenerate;
import com.cmeza.sdgenerator.provider.ClassPathScanningProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Entity;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ScanningConfigurationSupport {
    private final Environment environment;
    private final AnnotationAttributes attributes;
    private final AnnotationMetadata annotationMetadata;
    private final String[] entityPackage;
    private final boolean onlyAnnotations;

    public ScanningConfigurationSupport(AnnotationMetadata annotationMetadata, AnnotationAttributes attributes, Environment environment) {
        Assert.notNull((Object)environment, (String)"Environment must not be null!");
        Assert.notNull((Object)environment, (String)"AnnotationMetadata must not be null!");
        this.environment = environment;
        this.attributes = attributes;
        this.annotationMetadata = annotationMetadata;
        this.entityPackage = this.attributes.getStringArray("entityPackage");
        this.onlyAnnotations = this.attributes.getBoolean("onlyAnnotations");
    }

    public ScanningConfigurationSupport(String[] entityPackage, boolean onlyAnnotations) {
        this.entityPackage = entityPackage;
        this.onlyAnnotations = onlyAnnotations;
        this.environment = null;
        this.annotationMetadata = null;
        this.attributes = null;
    }

    public Iterable<String> getBasePackages() {
        if (this.entityPackage.length == 0) {
            String className = this.annotationMetadata.getClassName();
            return Collections.singleton(ClassUtils.getPackageName((String)className));
        }
        return new HashSet<String>(Arrays.asList(this.entityPackage));
    }

    public Collection<BeanDefinition> getCandidates(ResourceLoader resourceLoader) {
        if (this.getBasePackages() == null) {
            return Collections.emptyList();
        }
        ClassPathScanningProvider scanner = new ClassPathScanningProvider();
        scanner.setResourceLoader(resourceLoader);
        if (this.environment != null) {
            scanner.setEnvironment(this.environment);
        }
        scanner.setIncludeAnnotation(SDGenerate.class);
        scanner.setExcludeAnnotation(SDNoGenerate.class);
        if (!this.onlyAnnotations) {
            scanner.setIncludeAnnotation(Entity.class);
            scanner.setIncludeAnnotation(jakarta.persistence.Entity.class);
        }
        Iterator<String> filterPackages = this.getBasePackages().iterator();
        HashSet<BeanDefinition> candidates = new HashSet<BeanDefinition>();
        while (filterPackages.hasNext()) {
            String basePackage = filterPackages.next();
            Set candidate = scanner.findCandidateComponents(basePackage);
            candidates.addAll(candidate);
        }
        return candidates;
    }
}

