/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.support.maker;

import com.cmeza.sdgenerator.support.maker.builder.ObjectBuilder;
import com.cmeza.sdgenerator.support.maker.builder.ObjectStructure;
import com.cmeza.sdgenerator.support.maker.values.ObjectTypeValues;
import com.cmeza.sdgenerator.support.maker.values.ScopeValues;
import com.cmeza.sdgenerator.util.CustomResourceLoader;
import com.cmeza.sdgenerator.util.GeneratorException;
import com.cmeza.sdgenerator.util.GeneratorUtils;
import com.cmeza.sdgenerator.util.SDLogger;
import com.cmeza.sdgenerator.util.Tuple;
import jakarta.persistence.Id;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EmbeddedId;

public class RepositoryStructure {
    private static final Map<Class<?>, Class<?>> mapConvert = new HashMap();
    private final CustomResourceLoader loader;
    private ObjectBuilder objectBuilder;
    private Integer error = 0;

    public RepositoryStructure(String repositoryPackage, String entityName, String entityClass, String postfix, CustomResourceLoader loader, Set<String> additionalExtends, boolean withComments, boolean withJpaSpecificationExecutor) {
        this.loader = loader;
        String repositoryName = entityName + postfix;
        Tuple<String, Boolean> entityId = this.getEntityId(entityClass);
        if (entityId != null) {
            ObjectStructure objectStructure = new ObjectStructure(repositoryPackage, ScopeValues.PUBLIC, ObjectTypeValues.INTERFACE, repositoryName).addImport(entityClass).addImport("org.springframework.data.jpa.repository.JpaRepository").addImport("org.springframework.stereotype.Repository").addImport(entityId.right() != false ? entityId.left() : "").addAnnotation("Repository").addExtend("JpaRepository", entityName, GeneratorUtils.getSimpleClassName(entityId.left()));
            if (withJpaSpecificationExecutor) {
                objectStructure.addImport("org.springframework.data.jpa.repository.JpaSpecificationExecutor");
                objectStructure.addExtend("JpaSpecificationExecutor", entityName);
            }
            if (additionalExtends != null) {
                for (String additionalExtend : additionalExtends) {
                    objectStructure.addImport(additionalExtend);
                    objectStructure.addExtend(GeneratorUtils.getSimpleClassName(additionalExtend), entityName);
                }
            }
            this.objectBuilder = new ObjectBuilder(objectStructure).setWithComments(withComments);
        }
    }

    private Tuple<String, Boolean> getEntityId(String entityClass) {
        try {
            for (Class<?> entity = this.loader == null ? Class.forName(entityClass) : this.loader.getUrlClassLoader().loadClass(entityClass); entity != null; entity = entity.getSuperclass()) {
                for (Field field : entity.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(javax.persistence.Id.class) && !field.isAnnotationPresent(EmbeddedId.class) && !field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(jakarta.persistence.EmbeddedId.class)) continue;
                    Class<?> dataType = field.getType();
                    if (field.getType().isPrimitive()) {
                        dataType = this.primitiveToObject(field.getType());
                    }
                    return new Tuple<String, Boolean>(dataType.getName(), this.isCustomType(dataType));
                }
                for (AccessibleObject accessibleObject : entity.getDeclaredMethods()) {
                    if ((((Method)accessibleObject).getReturnType().equals(Void.TYPE) || !accessibleObject.isAnnotationPresent(javax.persistence.Id.class) && !accessibleObject.isAnnotationPresent(EmbeddedId.class)) && !accessibleObject.isAnnotationPresent(Id.class) && !accessibleObject.isAnnotationPresent(jakarta.persistence.EmbeddedId.class)) continue;
                    Class<?> dataType = ((Method)accessibleObject).getReturnType();
                    if (((Method)accessibleObject).getReturnType().isPrimitive()) {
                        dataType = this.primitiveToObject(((Method)accessibleObject).getReturnType());
                    }
                    return new Tuple<String, Boolean>(dataType.getName(), this.isCustomType(dataType));
                }
            }
            this.error = SDLogger.addError("Repository Error: Primary key not found in " + GeneratorUtils.getSimpleClassName(entityClass) + ".java");
            return null;
        }
        catch (GeneratorException ex) {
            this.error = SDLogger.addError(ex.getMessage());
            return null;
        }
        catch (Exception e) {
            this.error = SDLogger.addError("Repository Error: Failed to access entity " + GeneratorUtils.getSimpleClassName(entityClass) + ".java");
            return null;
        }
    }

    public Tuple<String, Integer> build() {
        return new Tuple<String, Integer>(this.objectBuilder == null ? null : this.objectBuilder.build(), this.error);
    }

    private boolean isCustomType(Class<?> clazz) {
        return !clazz.isAssignableFrom(Boolean.class) && !clazz.isAssignableFrom(Byte.class) && !clazz.isAssignableFrom(String.class) && !clazz.isAssignableFrom(Integer.class) && !clazz.isAssignableFrom(Long.class) && !clazz.isAssignableFrom(Float.class) && !clazz.isAssignableFrom(Double.class);
    }

    private Class<?> primitiveToObject(Class<?> clazz) {
        Class<?> convertResult = mapConvert.get(clazz);
        if (convertResult == null) {
            throw new GeneratorException("Type parameter '" + clazz.getName() + "' is incorrect");
        }
        return convertResult;
    }

    static {
        mapConvert.put(Boolean.TYPE, Boolean.class);
        mapConvert.put(Byte.TYPE, Byte.class);
        mapConvert.put(Short.TYPE, Short.class);
        mapConvert.put(Character.TYPE, Character.class);
        mapConvert.put(Integer.TYPE, Integer.class);
        mapConvert.put(Long.TYPE, Long.class);
        mapConvert.put(Float.TYPE, Float.class);
        mapConvert.put(Double.TYPE, Double.class);
    }
}

