/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.support.maker.builder;

import com.cmeza.sdgenerator.support.maker.builder.ObjectStructure;
import com.cmeza.sdgenerator.support.maker.values.CommonValues;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ObjectBuilder {
    private ObjectStructure objectStructure;
    private boolean attributeBottom;
    private boolean withComments;

    public ObjectBuilder(ObjectStructure objectStructure) {
        this.objectStructure = objectStructure;
    }

    public ObjectBuilder(ObjectStructure objectStructure, boolean attributeBottom) {
        this.objectStructure = objectStructure;
        this.attributeBottom = attributeBottom;
    }

    public ObjectBuilder setAttributeBottom(boolean attributeBottom) {
        this.attributeBottom = attributeBottom;
        return this;
    }

    public ObjectBuilder setWithComments(boolean withComments) {
        this.withComments = withComments;
        return this;
    }

    private String buildComments() {
        if (this.withComments) {
            SimpleDateFormat smf = new SimpleDateFormat("dd/MM/yyy");
            return CommonValues.COMMENT_START.getValue() + CommonValues.COMMENT_BODY.getValue() + String.format("Generated by %s on ", "Spring Data Generator") + smf.format(new Date()) + CommonValues.NEWLINE.getValue() + CommonValues.COMMENT_END.getValue();
        }
        return CommonValues.NONE.getValue();
    }

    public String build() {
        return this.objectStructure.getObjectPackage() + CommonValues.NEWLINE.getValue() + this.objectStructure.getObjectImports() + this.buildComments() + this.objectStructure.getObjectAnnotations() + (Object)((Object)this.objectStructure.getObjectScope()) + (Object)((Object)this.objectStructure.getObjectType()) + this.objectStructure.getObjectName() + this.objectStructure.getObjectExtend() + this.objectStructure.getObjectImplements() + CommonValues.KEY_START.getValue() + (!this.attributeBottom ? this.objectStructure.getObjectAttributes() : "") + (!this.attributeBottom ? this.objectStructure.getObjectFinalAttributes() : "") + this.objectStructure.getObjectConstructors() + this.objectStructure.getObjectMethods() + this.objectStructure.getObjectFunctions() + this.objectStructure.getObjectRawBody() + (this.attributeBottom ? this.objectStructure.getObjectAttributes() : "") + (this.attributeBottom ? this.objectStructure.getObjectFinalAttributes() : "") + CommonValues.NEWLINE.getValue() + CommonValues.KEY_END.getValue();
    }
}

