/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.support.maker.builder;

import com.cmeza.sdgenerator.support.maker.values.CommonValues;
import com.cmeza.sdgenerator.support.maker.values.ObjectTypeValues;
import com.cmeza.sdgenerator.support.maker.values.ObjectValues;
import com.cmeza.sdgenerator.support.maker.values.ScopeValues;
import com.cmeza.sdgenerator.util.BuildUtils;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;

public class ObjectStructure {
    private final ObjectTypeValues objectType;
    private final ScopeValues objectScope;
    private String objectPackage;
    private final Set<String> objectImports = new LinkedHashSet<String>();
    private final Set<String> objectAnnotations = new LinkedHashSet<String>();
    private final Set<String> objectImplements = new LinkedHashSet<String>();
    private final Set<String> objectAttributes = new LinkedHashSet<String>();
    private final Set<String> objectFinalAttributes = new LinkedHashSet<String>();
    private final Set<ObjectMethod> objectMethods = new LinkedHashSet<ObjectMethod>();
    private final Set<ObjectFunction> objectFunctions = new LinkedHashSet<ObjectFunction>();
    private final Set<ObjectConstructor> objectConstructors = new LinkedHashSet<ObjectConstructor>();
    private final Set<String> objectExtends = new LinkedHashSet<String>();
    private final String objectName;
    private boolean lombokAnnotations;
    private String objectRawBody;

    public ObjectStructure(String objectPackage, ScopeValues objectScope, ObjectTypeValues objectType, String objectName) {
        this.objectPackage = BuildUtils.buildPackage(objectPackage);
        this.objectScope = objectScope;
        this.objectType = objectType;
        this.objectName = BuildUtils.cleanSpaces(objectName);
        this.objectRawBody = "";
    }

    public ObjectStructure setPackage(String objectPackage) {
        if (!objectPackage.isEmpty()) {
            this.objectPackage = BuildUtils.buildPackage(objectPackage);
        }
        return this;
    }

    public ObjectStructure addImport(String objectImport) {
        if (!objectImport.isEmpty()) {
            this.objectImports.add(BuildUtils.buildImport(objectImport));
        }
        return this;
    }

    public ObjectStructure addImport(Class<?> clazz) {
        if (clazz != null) {
            this.objectImports.add(BuildUtils.buildImport(clazz.getName()));
        }
        return this;
    }

    public ObjectStructure addAnnotation(String annotation) {
        if (!annotation.isEmpty()) {
            this.objectAnnotations.add(BuildUtils.buildAnnotation(annotation));
        }
        return this;
    }

    public ObjectStructure addAnnotation(Class<?> clazz) {
        if (clazz != null) {
            this.objectAnnotations.add(BuildUtils.buildAnnotation(clazz.getSimpleName()));
        }
        return this;
    }

    public ObjectStructure addImplement(String objectImplement, Object ... objects) {
        this.objectImplements.add(BuildUtils.builDiamond(objectImplement, objects));
        return this;
    }

    public ObjectStructure addImplement(Class<?> clazz, Object ... objects) {
        if (clazz != null) {
            this.objectImplements.add(BuildUtils.builDiamond(clazz.getSimpleName(), objects));
        }
        return this;
    }

    public ObjectStructure addExtend(String objectExtend, Object ... objects) {
        this.objectExtends.add(BuildUtils.builDiamond(objectExtend, objects));
        return this;
    }

    public ObjectStructure addExtend(Class<?> clazz, Object ... objects) {
        this.objectExtends.add(BuildUtils.builDiamond(clazz.getSimpleName(), objects));
        return this;
    }

    public ObjectStructure setObjectRawBody(String objectRawBody) {
        this.objectRawBody = objectRawBody;
        return this;
    }

    public ObjectStructure addConstructor(ObjectConstructor objectConstructor) {
        if (objectConstructor != null) {
            this.objectConstructors.add(objectConstructor);
        }
        return this;
    }

    public ObjectStructure addAttribute(String attributeClass, String attribute) {
        this.objectAttributes.add(BuildUtils.buildAttribute(attributeClass, attribute, false));
        return this;
    }

    public ObjectStructure addFinalAttribute(String attributeClass, String attribute) {
        this.objectFinalAttributes.add(BuildUtils.buildAttribute(attributeClass, attribute, true));
        return this;
    }

    public ObjectStructure addMethod(ObjectMethod objectMethod) {
        this.objectMethods.add(objectMethod);
        return this;
    }

    public ObjectStructure addFunction(ObjectFunction objectFunction) {
        this.objectFunctions.add(objectFunction);
        return this;
    }

    public ObjectStructure setLombokAnnotations(boolean lombokAnnotations) {
        this.lombokAnnotations = lombokAnnotations;
        return this;
    }

    public ObjectTypeValues getObjectType() {
        return this.objectType;
    }

    public ScopeValues getObjectScope() {
        return this.objectScope;
    }

    public String getObjectPackage() {
        return this.objectPackage;
    }

    public String getObjectImports() {
        LinkedList<String> objectImportsOrder = new LinkedList<String>(this.objectImports);
        if (this.lombokAnnotations) {
            objectImportsOrder.add(BuildUtils.buildImport("lombok.RequiredArgsConstructor"));
            BuildUtils.removeImport(objectImportsOrder, Autowired.class.getName());
        }
        objectImportsOrder.sort(Comparator.comparing(String::toString));
        StringBuilder concat = new StringBuilder("");
        for (String str : objectImportsOrder) {
            concat.append(str);
        }
        if (!objectImportsOrder.isEmpty()) {
            concat.append((Object)CommonValues.NEWLINE);
        }
        return concat.toString();
    }

    public String getObjectAnnotations() {
        StringBuilder concat = new StringBuilder("");
        if (this.lombokAnnotations) {
            this.objectAnnotations.add(BuildUtils.buildAnnotation(RequiredArgsConstructor.class.getSimpleName()));
        }
        for (String str : this.objectAnnotations) {
            concat.append(str);
        }
        return concat.toString();
    }

    public String getObjectImplements() {
        StringBuilder concat = new StringBuilder("");
        int position = 0;
        for (String str : this.objectImplements) {
            concat.append(str);
            if (position != this.objectImplements.size() - 1) {
                concat.append((Object)CommonValues.COMA);
            }
            ++position;
        }
        return this.objectImplements.isEmpty() ? "" : CommonValues.SPACE.getValue() + ObjectValues.IMPLEMENTS.getValue() + concat;
    }

    public String getObjectAttributes() {
        StringBuilder concat = new StringBuilder("");
        for (String str : this.objectAttributes) {
            concat.append(str);
        }
        return !this.objectAttributes.isEmpty() ? CommonValues.NEWLINE.getValue() + concat : "";
    }

    public String getObjectFinalAttributes() {
        StringBuilder concat = new StringBuilder("");
        for (String str : this.objectFinalAttributes) {
            concat.append(str);
        }
        return !this.objectFinalAttributes.isEmpty() ? CommonValues.NEWLINE.getValue() + concat : "";
    }

    public int getObjectAttributesSize() {
        return this.objectAttributes.size();
    }

    public String getObjectMethods() {
        StringBuilder concat = new StringBuilder("");
        int position = 0;
        for (ObjectMethod method : this.objectMethods) {
            concat.append(method);
            if (position != this.objectMethods.size() - 1) {
                concat.append((Object)CommonValues.NEWLINE);
            }
            ++position;
        }
        return !this.objectMethods.isEmpty() ? CommonValues.NEWLINE.getValue() + concat : "";
    }

    public String getObjectFunctions() {
        StringBuilder concat = new StringBuilder("");
        int position = 0;
        for (ObjectFunction function : this.objectFunctions) {
            concat.append(function);
            if (position != this.objectFunctions.size() - 1) {
                concat.append((Object)CommonValues.NEWLINE);
            }
            ++position;
        }
        return !this.objectFunctions.isEmpty() ? CommonValues.NEWLINE.getValue() + concat : "";
    }

    public String getObjectConstructors() {
        if (!this.lombokAnnotations) {
            StringBuilder concat = new StringBuilder("");
            int position = 0;
            for (ObjectConstructor constructor : this.objectConstructors) {
                concat.append(constructor);
                if (position != this.objectConstructors.size() - 1) {
                    concat.append((Object)CommonValues.NEWLINE);
                }
                ++position;
            }
            return !this.objectConstructors.isEmpty() ? CommonValues.NEWLINE.getValue() + concat : "";
        }
        return CommonValues.NONE.getValue();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectExtend() {
        return this.objectExtends.isEmpty() ? "" : CommonValues.SPACE.getValue() + ObjectValues.EXTENDS.getValue() + StringUtils.join(this.objectExtends, (String)", ");
    }

    public String getObjectRawBody() {
        return this.objectRawBody.isEmpty() ? "" : CommonValues.NEWLINE.getValue() + this.objectRawBody;
    }

    public static class ObjectMethod {
        private final ScopeValues methodScope;
        private final String methodName;
        private final Set<Pair<Object, Object>> methodArguments = new LinkedHashSet<Pair<Object, Object>>();
        private String methodBody;
        private String methodAnnotations;

        public ObjectMethod(ScopeValues methodScope, String methodName) {
            this.methodScope = methodScope;
            this.methodName = BuildUtils.cleanSpaces(methodName);
            this.methodBody = "";
            this.methodAnnotations = "";
        }

        public ObjectMethod addArgument(String argumentClass, String argumentName) {
            this.methodArguments.add((Pair<Object, Object>)Pair.of((Object)BuildUtils.cleanSpaces(argumentClass), (Object)BuildUtils.cleanSpaces(argumentName)));
            return this;
        }

        public ObjectMethod setBody(String methodBody) {
            this.methodBody = methodBody;
            return this;
        }

        public ObjectMethod addBodyLine(String methodBody) {
            this.methodBody = this.methodBody + BuildUtils.buildBodyLine(methodBody);
            return this;
        }

        public ObjectMethod addAnnotation(String methodAnnotation) {
            this.methodAnnotations = this.methodAnnotations + BuildUtils.buildAnnotation(methodAnnotation);
            return this;
        }

        public ObjectMethod addAnnotation(Class<?> clazz) {
            if (clazz != null) {
                this.methodAnnotations = this.methodAnnotations + BuildUtils.buildAnnotation(clazz.getSimpleName());
            }
            return this;
        }

        public String toString() {
            return BuildUtils.buildMethod(this.methodAnnotations, this.methodScope, this.methodName, this.methodArguments, this.methodBody);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectMethod that = (ObjectMethod)o;
            if (this.methodScope != that.methodScope) {
                return false;
            }
            if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
                return false;
            }
            if (this.methodArguments != null ? !this.methodArguments.equals(that.methodArguments) : that.methodArguments != null) {
                return false;
            }
            if (this.methodBody != null ? !this.methodBody.equals(that.methodBody) : that.methodBody != null) {
                return false;
            }
            return this.methodAnnotations != null ? this.methodAnnotations.equals(that.methodAnnotations) : that.methodAnnotations == null;
        }

        public int hashCode() {
            int result = this.methodScope != null ? this.methodScope.hashCode() : 0;
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + (this.methodArguments != null ? this.methodArguments.hashCode() : 0);
            result = 31 * result + (this.methodBody != null ? this.methodBody.hashCode() : 0);
            result = 31 * result + (this.methodAnnotations != null ? this.methodAnnotations.hashCode() : 0);
            return result;
        }
    }

    public static class ObjectFunction {
        private final ScopeValues functionScope;
        private final String functionName;
        private final String functionReturnType;
        private final Set<Pair<Object, Object>> functionArguments = new LinkedHashSet<Pair<Object, Object>>();
        private String functionBody;
        private String functionAnnotations;
        private String functionReturn;

        public ObjectFunction(ScopeValues functionScope, String functionName, String functionReturnType) {
            this.functionScope = functionScope;
            this.functionName = BuildUtils.cleanSpaces(functionName);
            this.functionReturnType = BuildUtils.cleanSpaces(functionReturnType);
            this.functionBody = "";
            this.functionAnnotations = "";
            this.functionReturn = "";
        }

        public ObjectFunction addArgument(String argumentClass, String argumentName) {
            this.functionArguments.add((Pair<Object, Object>)Pair.of((Object)BuildUtils.cleanSpaces(argumentClass), (Object)BuildUtils.cleanSpaces(argumentName)));
            return this;
        }

        public ObjectFunction setBody(String functionBody) {
            this.functionBody = functionBody;
            return this;
        }

        public ObjectFunction addBodyLine(String functionBody) {
            this.functionBody = this.functionBody + BuildUtils.buildBodyLine(functionBody);
            return this;
        }

        public ObjectFunction addAnnotation(String functionAnnotation) {
            this.functionAnnotations = this.functionAnnotations + BuildUtils.buildAnnotation(functionAnnotation);
            return this;
        }

        public ObjectFunction addAnnotation(Class<?> clazz) {
            if (clazz != null) {
                this.functionAnnotations = this.functionAnnotations + BuildUtils.buildAnnotation(clazz.getSimpleName());
            }
            return this;
        }

        public ObjectFunction setFunctionReturn(String functionReturn) {
            this.functionReturn = BuildUtils.cleanSpaces(functionReturn);
            return this;
        }

        public String toString() {
            return BuildUtils.buildFunction(this.functionAnnotations, this.functionScope, this.functionReturnType, this.functionName, this.functionArguments, this.functionBody, this.functionReturn);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectFunction that = (ObjectFunction)o;
            if (this.functionScope != that.functionScope) {
                return false;
            }
            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) {
                return false;
            }
            if (this.functionReturnType != null ? !this.functionReturnType.equals(that.functionReturnType) : that.functionReturnType != null) {
                return false;
            }
            if (this.functionArguments != null ? !this.functionArguments.equals(that.functionArguments) : that.functionArguments != null) {
                return false;
            }
            if (this.functionBody != null ? !this.functionBody.equals(that.functionBody) : that.functionBody != null) {
                return false;
            }
            if (this.functionAnnotations != null ? !this.functionAnnotations.equals(that.functionAnnotations) : that.functionAnnotations != null) {
                return false;
            }
            return this.functionReturn != null ? this.functionReturn.equals(that.functionReturn) : that.functionReturn == null;
        }

        public int hashCode() {
            int result = this.functionScope != null ? this.functionScope.hashCode() : 0;
            result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
            result = 31 * result + (this.functionReturnType != null ? this.functionReturnType.hashCode() : 0);
            result = 31 * result + (this.functionArguments != null ? this.functionArguments.hashCode() : 0);
            result = 31 * result + (this.functionBody != null ? this.functionBody.hashCode() : 0);
            result = 31 * result + (this.functionAnnotations != null ? this.functionAnnotations.hashCode() : 0);
            result = 31 * result + (this.functionReturn != null ? this.functionReturn.hashCode() : 0);
            return result;
        }
    }

    public static class ObjectConstructor {
        private final ScopeValues constructorScope;
        private final String constructorName;
        private final Set<Pair<Object, Object>> constructorArguments = new LinkedHashSet<Pair<Object, Object>>();
        private String constructorBody;
        private String constructorAnnotations;

        public ObjectConstructor(ScopeValues constructorScope, String constructorName) {
            this.constructorScope = constructorScope;
            this.constructorName = BuildUtils.cleanSpaces(constructorName);
            this.constructorAnnotations = "";
            this.constructorBody = "";
        }

        public ObjectConstructor addArgument(String argumentClass, String argumentName) {
            this.constructorArguments.add((Pair<Object, Object>)Pair.of((Object)BuildUtils.cleanSpaces(argumentClass), (Object)BuildUtils.cleanSpaces(argumentName)));
            return this;
        }

        public ObjectConstructor setBody(String constructorBody) {
            this.constructorBody = constructorBody;
            return this;
        }

        public ObjectConstructor addBodyLine(String constructorBody) {
            this.constructorBody = this.constructorBody + BuildUtils.buildBodyLine(constructorBody);
            return this;
        }

        public ObjectConstructor addAnnotation(String constructorAnnotation) {
            this.constructorAnnotations = this.constructorAnnotations + BuildUtils.buildAnnotation(constructorAnnotation);
            return this;
        }

        public ObjectConstructor addAnnotation(Class<?> clazz) {
            if (clazz != null) {
                this.constructorAnnotations = this.constructorAnnotations + BuildUtils.buildAnnotation(clazz.getSimpleName());
            }
            return this;
        }

        public String toString() {
            return BuildUtils.buildConstructor(this.constructorAnnotations, this.constructorScope, this.constructorName, this.constructorArguments, this.constructorBody);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectConstructor that = (ObjectConstructor)o;
            if (this.constructorScope != that.constructorScope) {
                return false;
            }
            if (this.constructorName != null ? !this.constructorName.equals(that.constructorName) : that.constructorName != null) {
                return false;
            }
            if (this.constructorArguments != null ? !this.constructorArguments.equals(that.constructorArguments) : that.constructorArguments != null) {
                return false;
            }
            if (this.constructorBody != null ? !this.constructorBody.equals(that.constructorBody) : that.constructorBody != null) {
                return false;
            }
            return this.constructorAnnotations != null ? this.constructorAnnotations.equals(that.constructorAnnotations) : that.constructorAnnotations == null;
        }

        public int hashCode() {
            int result = this.constructorScope != null ? this.constructorScope.hashCode() : 0;
            result = 31 * result + (this.constructorName != null ? this.constructorName.hashCode() : 0);
            result = 31 * result + (this.constructorArguments != null ? this.constructorArguments.hashCode() : 0);
            result = 31 * result + (this.constructorBody != null ? this.constructorBody.hashCode() : 0);
            result = 31 * result + (this.constructorAnnotations != null ? this.constructorAnnotations.hashCode() : 0);
            return result;
        }
    }
}

