/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.util;

import com.cmeza.sdgenerator.support.maker.values.AccessValues;
import com.cmeza.sdgenerator.support.maker.values.CommonValues;
import com.cmeza.sdgenerator.support.maker.values.ExpressionValues;
import com.cmeza.sdgenerator.support.maker.values.ObjectValues;
import com.cmeza.sdgenerator.support.maker.values.ScopeValues;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class BuildUtils {
    private BuildUtils() {
    }

    public static String cleanSpaces(String str) {
        return str.replace(" ", "");
    }

    public static String buildPackage(String objectPackage) {
        return ObjectValues.PACKAGE + BuildUtils.cleanSpaces(objectPackage) + CommonValues.SEMICOLON;
    }

    public static String buildImport(String objectImport) {
        return ObjectValues.IMPORT + BuildUtils.cleanSpaces(objectImport) + CommonValues.SEMICOLON;
    }

    public static void removeImport(List<String> objectsImport, String importTag) {
        objectsImport.removeIf(e -> e.equalsIgnoreCase(ObjectValues.IMPORT + BuildUtils.cleanSpaces(importTag) + CommonValues.SEMICOLON));
    }

    public static String buildAttribute(String attributeClass, String attributeName, boolean hasFinal) {
        return CommonValues.TAB + ScopeValues.PRIVATE.getValue() + (hasFinal ? AccessValues.FINAL.getValue() : "") + BuildUtils.cleanSpaces(attributeClass) + CommonValues.SPACE + BuildUtils.cleanSpaces(attributeName) + CommonValues.SEMICOLON;
    }

    public static String builDiamond(String objectClass, Object ... objects) {
        if (objects != null && objects.length > 0) {
            StringBuilder diamondString = new StringBuilder();
            diamondString.append(BuildUtils.cleanSpaces(objectClass));
            diamondString.append((Object)CommonValues.DIAMOND_START);
            for (Object obj : objects) {
                diamondString.append(BuildUtils.cleanSpaces(String.valueOf(obj)));
                if (String.valueOf(objects[objects.length - 1]).equals(String.valueOf(obj))) continue;
                diamondString.append((Object)CommonValues.COMA);
            }
            diamondString.append((Object)CommonValues.DIAMOND_END);
            return diamondString.toString();
        }
        return BuildUtils.cleanSpaces(objectClass);
    }

    public static String buildAnnotation(String annotation) {
        return (String)(annotation.startsWith(ExpressionValues.AT.getValue()) ? BuildUtils.cleanSpaces(annotation) : ExpressionValues.AT + BuildUtils.cleanSpaces(annotation)) + CommonValues.NEWLINE;
    }

    public static String buildBodyLine(String bodyLine) {
        return CommonValues.TAB.getValue() + CommonValues.TAB.getValue() + bodyLine + CommonValues.SEMICOLON.getValue();
    }

    public static String buildReturn(String returnString) {
        return CommonValues.TAB.getValue() + CommonValues.TAB.getValue() + ObjectValues.RETURN.getValue() + returnString + CommonValues.SEMICOLON.getValue();
    }

    public static String buildConstructor(String annotations, ScopeValues scope, String objectName, Set<Pair<Object, Object>> arguments, String body) {
        return BuildUtils.buildStructure(annotations, scope, null, objectName, arguments, body, null);
    }

    public static String buildFunction(String annotations, ScopeValues scope, String returnStructure, String objectName, Set<Pair<Object, Object>> arguments, String body, String returnString) {
        return BuildUtils.buildStructure(annotations, scope, returnStructure, objectName, arguments, body, returnString);
    }

    public static String buildMethod(String annotations, ScopeValues scope, String objectName, Set<Pair<Object, Object>> arguments, String body) {
        return BuildUtils.buildStructure(annotations, scope, "void", objectName, arguments, body, null);
    }

    public static String buildStructure(String annotations, ScopeValues scope, String returnStructure, String objectName, Set<Pair<Object, Object>> arguments, String body, String returnString) {
        StringBuilder constructor = new StringBuilder();
        if (annotations != null && !annotations.isEmpty()) {
            constructor.append(CommonValues.TAB.getValue());
            constructor.append(annotations);
        }
        constructor.append((Object)CommonValues.TAB).append((Object)scope).append((String)(returnStructure == null ? "" : returnStructure + CommonValues.SPACE)).append(objectName).append((Object)CommonValues.PARENTHESIS);
        if (arguments != null && !arguments.isEmpty()) {
            int position = 0;
            for (Pair<Object, Object> obj : arguments) {
                constructor.append(obj.getKey()).append((Object)CommonValues.SPACE).append(obj.getValue());
                if (position != arguments.size() - 1) {
                    constructor.append((Object)CommonValues.COMA);
                }
                ++position;
            }
        }
        constructor.append((Object)CommonValues.PARENTHESIS_END).append((Object)CommonValues.KEY_START).append(body.isEmpty() ? CommonValues.NEWLINE : body).append(Objects.isNull(returnString) ? "" : (returnString.isEmpty() ? "" : BuildUtils.buildReturn(returnString))).append((Object)CommonValues.TAB).append((Object)CommonValues.KEY_END);
        return constructor.toString();
    }
}

