/*
 * Decompiled with CFR 0.152.
 */
package com.cmeza.sdgenerator.util;

import com.cmeza.sdgenerator.annotation.SDGenerator;
import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_LongestWordMin;
import de.vandermeer.asciithemes.a7.A7_Grids;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.logging.Log;

public class SDLogger {
    private static final org.apache.commons.logging.Log commonsLogger = LogFactory.getLog(SDGenerator.class);
    private static Log mavenLogger;
    private static int generated;
    private static final List<String> errors;
    private static final List<String> warns;
    private static final List<String> additionalExtend;
    private static AsciiTable generatedTable;

    private SDLogger() {
    }

    public static void configure(Log log) {
        mavenLogger = log;
    }

    public static void info(String message) {
        if (mavenLogger == null) {
            commonsLogger.info((Object)message);
            return;
        }
        mavenLogger.info((CharSequence)message);
    }

    public static void debug(String message) {
        if (mavenLogger == null) {
            commonsLogger.debug((Object)message);
            return;
        }
        mavenLogger.debug((CharSequence)message);
    }

    public static void error(String message) {
        if (mavenLogger == null) {
            commonsLogger.error((Object)message);
            return;
        }
        mavenLogger.error((CharSequence)message);
    }

    public static Integer addError(String message) {
        errors.add(message);
        return errors.size();
    }

    public static Integer addWarn(String warn) {
        warns.add(warn);
        return warns.size();
    }

    public static Integer addAdditionalExtend(String ext) {
        additionalExtend.add(ext);
        return additionalExtend.size();
    }

    private static void printErrors() {
        SDLogger.printGenericTable("Errors", errors);
    }

    private static void printWarns() {
        SDLogger.printGenericTable("Warnings", warns);
    }

    private static void printAdditionalExtends() {
        SDLogger.printGenericTable("Additional Extends", additionalExtend);
    }

    private static void br() {
        SDLogger.br(1);
    }

    private static void br(int iterate) {
        IntStream.iterate(0, i -> i++).limit(iterate).forEach(j -> {
            if (mavenLogger == null) {
                commonsLogger.info((Object)"");
                return;
            }
            mavenLogger.info((CharSequence)"");
        });
    }

    private static void printGenericTable(String title, List<String> messages) {
        AsciiTable table = new AsciiTable();
        table.addRule();
        ((AT_Cell)table.addRow(new Object[]{null, title + ": " + messages.size()}).getCells().get(1)).getContext().setTextAlignment(TextAlignment.CENTER);
        table.addRule();
        int count = 1;
        for (String mess : messages) {
            ((AT_Cell)table.addRow(new Object[]{"#" + count, mess}).getCells().get(0)).getContext().setTextAlignment(TextAlignment.CENTER);
            table.addRule();
            ++count;
        }
        table.getContext().setGrid(A7_Grids.minusBarPlusEquals());
        table.getRenderer().setCWC((AT_ColumnWidthCalculator)new CWC_LongestWordMin(new int[]{5, 101}));
        table.renderAsCollection().forEach(SDLogger::info);
    }

    public static void addRowGeneratedTable(Object ... columns) {
        if (generatedTable == null) {
            SDLogger.initializeTable();
        }
        generatedTable.addRule();
        AT_Row row = generatedTable.addRow(columns);
        if (columns[0] != null) {
            ((AT_Cell)row.getCells().get(0)).getContext().setTextAlignment(TextAlignment.CENTER);
        }
        if (columns[2] != null) {
            ((AT_Cell)row.getCells().get(2)).getContext().setTextAlignment(TextAlignment.CENTER);
        }
    }

    public static void printGeneratedTables(boolean debug) {
        if (debug && generatedTable == null) {
            SDLogger.initializeTable();
        }
        if (generatedTable != null) {
            SDLogger.br();
            SDLogger.printBanner();
            SDLogger.br();
            if (!additionalExtend.isEmpty()) {
                SDLogger.br();
                SDLogger.printAdditionalExtends();
                SDLogger.br(2);
            }
            if (generated > 0) {
                SDLogger.addRowGeneratedTable(null, null, generated + " files generated");
            } else {
                SDLogger.addRowGeneratedTable(null, null, "No files generated");
            }
            generatedTable.addRule();
            generatedTable.getContext().setGrid(A7_Grids.minusBarPlusEquals());
            generatedTable.getRenderer().setCWC((AT_ColumnWidthCalculator)new CWC_LongestWordMin(new int[]{20, 68, 17}));
            generatedTable.renderAsCollection().forEach(SDLogger::info);
            SDLogger.br();
            if (!warns.isEmpty()) {
                SDLogger.printWarns();
                SDLogger.br(2);
            }
        } else {
            SDLogger.info(String.format("\u001b[1m\u001b[43m  %s:\u001b[0m\u001b[43m %s files generated  \u001b[0m", "Spring Data Generator", generated));
        }
        if (!errors.isEmpty()) {
            SDLogger.br();
            SDLogger.printErrors();
            SDLogger.br(2);
        }
    }

    private static void initializeTable() {
        generatedTable = new AsciiTable();
        generatedTable.addRule();
        AT_Row header = generatedTable.addRow(new Object[]{"Postfix", "File Name", "Result"});
        header.getCells().forEach(c -> c.getContext().setTextAlignment(TextAlignment.CENTER));
    }

    public static void plusGenerated(int plus) {
        generated += plus;
    }

    private static void printBanner() {
        ArrayList<String> banner = new ArrayList<String>();
        banner.add("   _____            _                ____        __           ______                           __            ");
        banner.add("  / ___/____  _____(_)___  ____ _   / __ \\____ _/ /_____ _   / ____/__  ____  ___  _________ _/ /_____  _____");
        banner.add("  \\__ \\/ __ \\/ ___/ / __ \\/ __ `/  / / / / __ `/ __/ __ `/  / / __/ _ \\/ __ \\/ _ \\/ ___/ __ `/ __/ __ \\/ ___/");
        banner.add(" ___/ / /_/ / /  / / / / / /_/ /  / /_/ / /_/ / /_/ /_/ /  / /_/ /  __/ / / /  __/ /  / /_/ / /_/ /_/ / /    ");
        banner.add("/____/ .___/_/  /_/_/ /_/\\__, /  /_____/\\__,_/\\__/\\__,_/   \\____/\\___/_/ /_/\\___/_/   \\__,_/\\__/\\____/_/     ");
        banner.add("====/_/=================/____/======================================================================(v2.0.1)");
        banner.forEach(SDLogger::info);
    }

    static {
        generated = 0;
        errors = new ArrayList<String>();
        warns = new ArrayList<String>();
        additionalExtend = new ArrayList<String>();
    }
}

