/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import android.os.Parcel;
import android.os.Parcelable;
import com.cocoahero.android.geojson.Feature;
import com.cocoahero.android.geojson.GeoJSONObject;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeatureCollection
extends GeoJSONObject {
    public static final String JSON_FEATURES = "features";
    private final List<Feature> mFeatures = new ArrayList<Feature>();
    public static final Parcelable.Creator<FeatureCollection> CREATOR = new Parcelable.Creator<FeatureCollection>(){

        public FeatureCollection createFromParcel(Parcel in) {
            return (FeatureCollection)GeoJSONObject.readParcel(in);
        }

        public FeatureCollection[] newArray(int size) {
            return new FeatureCollection[size];
        }
    };

    public FeatureCollection() {
    }

    public FeatureCollection(JSONObject json) {
        super(json);
        JSONArray features = json.optJSONArray(JSON_FEATURES);
        if (features != null) {
            for (int i = 0; i < features.length(); ++i) {
                JSONObject featureJSON = features.optJSONObject(i);
                if (featureJSON == null) continue;
                this.mFeatures.add(new Feature(featureJSON));
            }
        }
    }

    public void addFeature(Feature feature) {
        this.mFeatures.add(feature);
    }

    public void removeFeature(Feature feature) {
        this.mFeatures.remove(feature);
    }

    public List<Feature> getFeatures() {
        return this.mFeatures;
    }

    public void setFeatures(List<Feature> features) {
        this.mFeatures.clear();
        if (features != null) {
            this.mFeatures.addAll(features);
        }
    }

    @Override
    public String getType() {
        return "FeatureCollection";
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = super.toJSON();
        JSONArray features = new JSONArray();
        for (Feature feature : this.mFeatures) {
            features.put((Object)feature.toJSON());
        }
        json.put(JSON_FEATURES, (Object)features);
        return json;
    }
}

