/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import android.os.Parcel;
import android.os.Parcelable;
import com.cocoahero.android.geojson.GeoJSON;
import com.cocoahero.android.geojson.GeoJSONObject;
import com.cocoahero.android.geojson.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeometryCollection
extends Geometry {
    public static final String JSON_GEOMETRIES = "geometries";
    private final List<Geometry> mGeometries = new ArrayList<Geometry>();
    public static final Parcelable.Creator<GeometryCollection> CREATOR = new Parcelable.Creator<GeometryCollection>(){

        public GeometryCollection createFromParcel(Parcel in) {
            return (GeometryCollection)GeoJSONObject.readParcel(in);
        }

        public GeometryCollection[] newArray(int size) {
            return new GeometryCollection[size];
        }
    };

    public GeometryCollection() {
    }

    public GeometryCollection(JSONObject json) {
        super(json);
        JSONArray geometries = json.optJSONArray(JSON_GEOMETRIES);
        if (geometries != null) {
            for (int i = 0; i < geometries.length(); ++i) {
                JSONObject geometry = geometries.optJSONObject(i);
                if (geometry == null) continue;
                this.mGeometries.add((Geometry)GeoJSON.parse(geometry));
            }
        }
    }

    public void addGeometry(Geometry geometry) {
        this.mGeometries.add(geometry);
    }

    public void removeGeometry(Geometry geometry) {
        this.mGeometries.remove(geometry);
    }

    public List<Geometry> getGeometries() {
        return this.mGeometries;
    }

    public void setGeometries(List<Geometry> geometries) {
        this.mGeometries.clear();
        if (geometries != null) {
            this.mGeometries.addAll(geometries);
        }
    }

    @Override
    public String getType() {
        return "GeometryCollection";
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = super.toJSON();
        JSONArray geometries = new JSONArray();
        for (Geometry geometry : this.mGeometries) {
            geometries.put((Object)geometry.toJSON());
        }
        json.put(JSON_GEOMETRIES, (Object)geometries);
        return json;
    }
}

