/*
 * Decompiled with CFR 0.152.
 */
package com.cocoahero.android.geojson;

import android.os.Parcel;
import android.os.Parcelable;
import com.cocoahero.android.geojson.GeoJSONObject;
import com.cocoahero.android.geojson.Geometry;
import com.cocoahero.android.geojson.Polygon;
import com.cocoahero.android.geojson.Ring;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiPolygon
extends Geometry {
    private final List<Polygon> mPolygons = new ArrayList<Polygon>();
    public static final Parcelable.Creator<MultiPolygon> CREATOR = new Parcelable.Creator<MultiPolygon>(){

        public MultiPolygon createFromParcel(Parcel in) {
            return (MultiPolygon)GeoJSONObject.readParcel(in);
        }

        public MultiPolygon[] newArray(int size) {
            return new MultiPolygon[size];
        }
    };

    public MultiPolygon() {
    }

    public MultiPolygon(JSONObject json) {
        super(json);
        this.setPolygons(json.optJSONArray("coordinates"));
    }

    public void addPolygon(Polygon polygon) {
        this.mPolygons.add(polygon);
    }

    public void removePolygon(Polygon polygon) {
        this.mPolygons.remove(polygon);
    }

    public List<Polygon> getPolygons() {
        return this.mPolygons;
    }

    public void setPolygons(JSONArray polygons) {
        this.mPolygons.clear();
        if (polygons != null) {
            for (int i = 0; i < polygons.length(); ++i) {
                JSONArray polyJSON = polygons.optJSONArray(i);
                if (polyJSON == null) continue;
                this.mPolygons.add(new Polygon(polyJSON));
            }
        }
    }

    public void setPolygons(List<Polygon> polygons) {
        this.mPolygons.clear();
        if (polygons != null) {
            this.mPolygons.addAll(polygons);
        }
    }

    @Override
    public String getType() {
        return "MultiPolygon";
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = super.toJSON();
        JSONArray polygons = new JSONArray();
        for (Polygon polygon : this.mPolygons) {
            JSONArray ringJSON = new JSONArray();
            for (Ring ring : polygon.getRings()) {
                ringJSON.put((Object)ring.toJSON());
            }
            polygons.put((Object)ringJSON);
        }
        json.put("coordinates", (Object)polygons);
        return json;
    }
}

