/*
 * Decompiled with CFR 0.152.
 */
package com.cocosw.lifecycle;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.cocosw.lifecycle.ActivityLifecycleCallbacksCompat;
import com.cocosw.lifecycle.ActivityLifecycleCallbacksWrapper;
import com.cocosw.lifecycle.FragmentLifecycleCallbacks;
import java.util.ArrayList;
import java.util.List;

public class LifecycleDispatcher
implements ActivityLifecycleCallbacksCompat,
FragmentLifecycleCallbacks {
    private static final LifecycleDispatcher INSTANCE = new LifecycleDispatcher();
    private static final boolean PRE_ICS = Build.VERSION.SDK_INT < 14;
    private List<ActivityLifecycleCallbacksCompat> mActivityLifecycleCallbacks = new ArrayList<ActivityLifecycleCallbacksCompat>();
    private List<FragmentLifecycleCallbacks> mFragmentLifecycleCallbacks = new ArrayList<FragmentLifecycleCallbacks>();

    public static LifecycleDispatcher get() {
        return INSTANCE;
    }

    private LifecycleDispatcher() {
    }

    public static void registerActivityLifecycleCallbacks(Application application, ActivityLifecycleCallbacksCompat callback) {
        if (PRE_ICS) {
            LifecycleDispatcher.preIcsRegisterActivityLifecycleCallbacks(callback);
        } else {
            LifecycleDispatcher.postIcsRegisterActivityLifecycleCallbacks(application, callback);
        }
    }

    private static void preIcsRegisterActivityLifecycleCallbacks(ActivityLifecycleCallbacksCompat callback) {
        LifecycleDispatcher.get().registerActivityLifecycleCallbacks(callback);
    }

    @TargetApi(value=14)
    private static void postIcsRegisterActivityLifecycleCallbacks(Application application, ActivityLifecycleCallbacksCompat callback) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksWrapper(callback));
    }

    public static void unregisterActivityLifecycleCallbacks(Application application, ActivityLifecycleCallbacksCompat callback) {
        if (PRE_ICS) {
            LifecycleDispatcher.preIcsUnregisterActivityLifecycleCallbacks(callback);
        } else {
            LifecycleDispatcher.postIcsUnregisterActivityLifecycleCallbacks(application, callback);
        }
    }

    private static void preIcsUnregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacksCompat callback) {
        LifecycleDispatcher.get().unregisterActivityLifecycleCallbacks(callback);
    }

    @TargetApi(value=14)
    private static void postIcsUnregisterActivityLifecycleCallbacks(Application application, ActivityLifecycleCallbacksCompat callback) {
        application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksWrapper(callback));
    }

    public static void registerFragmentLifecycleCallbacks(Application application, FragmentLifecycleCallbacks callback) {
        LifecycleDispatcher.get().registerFragmentLifecycleCallbacks(callback);
    }

    public static void unregisterFragmentLifecycleCallbacks(Application application, FragmentLifecycleCallbacks callback) {
        LifecycleDispatcher.get().unregisterFragmentLifecycleCallbacks(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActivityLifecycleCallbacks(ActivityLifecycleCallbacksCompat callback) {
        List<ActivityLifecycleCallbacksCompat> list = this.mActivityLifecycleCallbacks;
        synchronized (list) {
            this.mActivityLifecycleCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterActivityLifecycleCallbacks(ActivityLifecycleCallbacksCompat callback) {
        List<ActivityLifecycleCallbacksCompat> list = this.mActivityLifecycleCallbacks;
        synchronized (list) {
            this.mActivityLifecycleCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFragmentLifecycleCallbacks(FragmentLifecycleCallbacks callback) {
        List<FragmentLifecycleCallbacks> list = this.mFragmentLifecycleCallbacks;
        synchronized (list) {
            this.mFragmentLifecycleCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFragmentLifecycleCallbacks(FragmentLifecycleCallbacks callback) {
        List<FragmentLifecycleCallbacks> list = this.mFragmentLifecycleCallbacks;
        synchronized (list) {
            this.mFragmentLifecycleCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] collectActivityLifecycleCallbacks() {
        Object[] callbacks = null;
        List<ActivityLifecycleCallbacksCompat> list = this.mActivityLifecycleCallbacks;
        synchronized (list) {
            if (this.mActivityLifecycleCallbacks.size() > 0) {
                callbacks = this.mActivityLifecycleCallbacks.toArray();
            }
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] collectFragmentLifecycleCallbacks() {
        Object[] callbacks = null;
        List<FragmentLifecycleCallbacks> list = this.mFragmentLifecycleCallbacks;
        synchronized (list) {
            if (this.mFragmentLifecycleCallbacks.size() > 0) {
                callbacks = this.mFragmentLifecycleCallbacks.toArray();
            }
        }
        return callbacks;
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (!PRE_ICS) {
            return;
        }
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ActivityLifecycleCallbacksCompat)callback).onActivityCreated(activity, savedInstanceState);
            }
        }
    }

    @Override
    public void onActivityStarted(Activity activity) {
        if (!PRE_ICS) {
            return;
        }
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ActivityLifecycleCallbacksCompat)callback).onActivityStarted(activity);
            }
        }
    }

    @Override
    public void onActivityResumed(Activity activity) {
        if (!PRE_ICS) {
            return;
        }
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ActivityLifecycleCallbacksCompat)callback).onActivityResumed(activity);
            }
        }
    }

    @Override
    public void onActivityPaused(Activity activity) {
        if (!PRE_ICS) {
            return;
        }
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ActivityLifecycleCallbacksCompat)callback).onActivityPaused(activity);
            }
        }
    }

    @Override
    public void onActivityStopped(Activity activity) {
        if (!PRE_ICS) {
            return;
        }
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ActivityLifecycleCallbacksCompat)callback).onActivityStopped(activity);
            }
        }
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (!PRE_ICS) {
            return;
        }
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ActivityLifecycleCallbacksCompat)callback).onActivitySaveInstanceState(activity, outState);
            }
        }
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        if (!PRE_ICS) {
            return;
        }
        Object[] callbacks = this.collectActivityLifecycleCallbacks();
        if (callbacks != null) {
            for (Object callback : callbacks) {
                ((ActivityLifecycleCallbacksCompat)callback).onActivityDestroyed(activity);
            }
        }
    }

    @Override
    public void onFragmentActivityCreated(Fragment fragment, Bundle savedInstanceState) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentActivityCreated(fragment, savedInstanceState);
            }
        }
    }

    @Override
    public void onFragmentAttach(Fragment fragment, Activity activity) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentAttach(fragment, activity);
            }
        }
    }

    @Override
    public void onFragmentDetach(Fragment fragment) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentDetach(fragment);
            }
        }
    }

    @Override
    public void onFragmentCreated(Fragment fragment, Bundle savedInstanceState) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentCreated(fragment, savedInstanceState);
            }
        }
    }

    @Override
    public void onFragmentStarted(Fragment fragment) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentStarted(fragment);
            }
        }
    }

    @Override
    public void onFragmentResumed(Fragment fragment) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentResumed(fragment);
            }
        }
    }

    @Override
    public void onFragmentPaused(Fragment fragment) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentPaused(fragment);
            }
        }
    }

    @Override
    public void onFragmentStopped(Fragment fragment) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentStopped(fragment);
            }
        }
    }

    @Override
    public void onFragmentSaveInstanceState(Fragment fragment, Bundle outState) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentSaveInstanceState(fragment, outState);
            }
        }
    }

    @Override
    public void onFragmentDestroyed(Fragment fragment) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentDestroyed(fragment);
            }
        }
    }

    @Override
    public void onFragmentCreateView(Fragment fragment, LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentCreateView(fragment, inflater, container, savedInstanceState);
            }
        }
    }

    @Override
    public void onFragmentViewCreated(Fragment fragment, View view, Bundle savedInstanceState) {
        Object[] callbacks = this.collectFragmentLifecycleCallbacks();
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                ((FragmentLifecycleCallbacks)callbacks[i]).onFragmentViewCreated(fragment, view, savedInstanceState);
            }
        }
    }
}

