/*
 * Copyright (C) 2014 - 2016 Softwaremill <http://softwaremill.com>
 * Copyright (C) 2016 - 2019 Lightbend Inc. <http://www.lightbend.com>
 */

package akka.stream.impl.fusing

import java.util.concurrent.TimeUnit.NANOSECONDS

import akka.actor.{ ActorRef, Terminated }
import akka.annotation.{ DoNotInherit, InternalApi }
import akka.dispatch.ExecutionContexts
import akka.event.Logging.LogLevel
import akka.event.{ LogSource, Logging, LoggingAdapter }
import akka.stream.Attributes.{ InputBuffer, LogLevels }
import akka.stream.OverflowStrategies._
import akka.stream.impl.fusing.GraphStages.SimpleLinearGraphStage
import akka.stream.impl.{ ReactiveStreamsCompliance, Buffer ⇒ BufferImpl }
import akka.stream.scaladsl.{ Flow, Keep, Source }
import akka.stream.stage._
import akka.stream.{ Supervision, _ }
import scala.annotation.tailrec
import scala.collection.immutable
import scala.collection.immutable.VectorBuilder
import scala.concurrent.{ Future, Promise }
import scala.util.control.{ NoStackTrace, NonFatal }
import scala.util.{ Failure, Success, Try }

import akka.stream.ActorAttributes.SupervisionStrategy
import scala.concurrent.duration.{ FiniteDuration, _ }
import scala.util.control.Exception.Catcher

import akka.stream.impl.Stages.DefaultAttributes
import akka.util.OptionVal

/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */




/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * Maps error with the provided function if it is defined for an error or, otherwise, passes it on unchanged.
 *
 * While similar to [[Recover]] this operator can be used to transform an error signal to a different one *without* logging
 * it as an error in the process. So in that sense it is NOT exactly equivalent to `recover(t => throw t2)` since recover
 * would log the `t2` error.
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */




/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


@InternalApi private[akka] object GroupedWeightedWithin {
  val groupedWeightedWithinTimer = "GroupedWeightedWithinTimer"
}

/**
 * INTERNAL API
 */
@InternalApi private[akka] final class GroupedWeightedWithin[T](val maxWeight: Long, costFn: T ⇒ Long, val interval: FiniteDuration) extends GraphStage[FlowShape[T, immutable.Seq[T]]] {
  require(maxWeight > 0, "maxWeight must be greater than 0")
  require(interval > Duration.Zero)

  val in = Inlet[T]("in")
  val out = Outlet[immutable.Seq[T]]("out")

  override def initialAttributes = DefaultAttributes.groupedWeightedWithin

  val shape = FlowShape(in, out)

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new TimerGraphStageLogic(shape) with InHandler with OutHandler {

    private val buf: VectorBuilder[T] = new VectorBuilder
    private var pending: T = null.asInstanceOf[T]
    private var pendingWeight: Long = 0L
    // True if:
    // - buf is nonEmpty
    //       AND
    // - (timer fired
    //        OR
    //    totalWeight >= maxWeight
    //        OR
    //    pending != null
    //        OR
    //    upstream completed)
    private var pushEagerly = false
    private var groupEmitted = true
    private var finished = false
    private var totalWeight = 0L
    private var hasElements = false

    override def preStart() = {
      schedulePeriodically(GroupedWeightedWithin.groupedWeightedWithinTimer, interval)
      pull(in)
    }

    private def nextElement(elem: T): Unit = {
      groupEmitted = false
      val cost = costFn(elem)
      if (cost < 0L) failStage(new IllegalArgumentException(s"Negative weight [$cost] for element [$elem] is not allowed"))
      else {
        hasElements = true
        if (totalWeight + cost <= maxWeight) {
          buf += elem
          totalWeight += cost

          if (totalWeight < maxWeight) pull(in)
          else {
            // `totalWeight >= maxWeight` which means that downstream can get the next group.
            if (!isAvailable(out)) {
              // We should emit group when downstream becomes available
              pushEagerly = true
              // we want to pull anyway, since we allow for zero weight elements
              // but since `emitGroup()` will pull internally (by calling `startNewGroup()`)
              // we also have to pull if downstream hasn't yet requested an element.
              pull(in)
            } else {
              schedulePeriodically(GroupedWeightedWithin.groupedWeightedWithinTimer, interval)
              emitGroup()
            }
          }
        } else {
          //we have a single heavy element that weighs more than the limit
          if (totalWeight == 0L) {
            buf += elem
            totalWeight += cost
            pushEagerly = true
          } else {
            pending = elem
            pendingWeight = cost
          }
          schedulePeriodically(GroupedWeightedWithin.groupedWeightedWithinTimer, interval)
          tryCloseGroup()
        }
      }
    }

    private def tryCloseGroup(): Unit = {
      if (isAvailable(out)) emitGroup()
      else if (pending != null || finished) pushEagerly = true
    }

    private def emitGroup(): Unit = {
      groupEmitted = true
      push(out, buf.result())
      buf.clear()
      if (!finished) startNewGroup()
      else if (pending != null) emit(out, Vector(pending), () ⇒ completeStage())
      else completeStage()
    }

    private def startNewGroup(): Unit = {
      if (pending != null) {
        totalWeight = pendingWeight
        pendingWeight = 0L
        buf += pending
        pending = null.asInstanceOf[T]
        groupEmitted = false
      } else {
        totalWeight = 0L
        hasElements = false
      }
      pushEagerly = false
      if (isAvailable(in)) nextElement(grab(in))
      else if (!hasBeenPulled(in)) pull(in)
    }

    override def onPush(): Unit = {
      if (pending == null) nextElement(grab(in)) // otherwise keep the element for next round
    }

    override def onPull(): Unit = if (pushEagerly) emitGroup()

    override def onUpstreamFinish(): Unit = {
      finished = true
      if (groupEmitted) completeStage()
      else tryCloseGroup()
    }

    override protected def onTimer(timerKey: Any) = if (hasElements) {
      if (isAvailable(out)) emitGroup()
      else pushEagerly = true
    }

    setHandlers(in, out, this)
  }
}

/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */




/**
 * INTERNAL API
 */


/**
 * INTERNAL API
 */

