/*
 * Decompiled with CFR 0.152.
 */
package akka.kafka;

import akka.actor.ActorSystem;
import akka.kafka.ConsumerSettings;
import akka.kafka.internal.ConfigSettings$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$DurationOps$;
import com.typesafe.config.Config;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public final class ConsumerSettings$ {
    public static final ConsumerSettings$ MODULE$;
    private final String configPath;

    static {
        new ConsumerSettings$();
    }

    public String configPath() {
        return this.configPath;
    }

    public <K, V> ConsumerSettings<K, V> apply(ActorSystem system, Option<Deserializer<K>> keyDeserializer, Option<Deserializer<V>> valueDeserializer) {
        Config config = system.settings().config().getConfig(this.configPath());
        return this.apply(config, keyDeserializer, valueDeserializer);
    }

    public <K, V> ConsumerSettings<K, V> apply(Config config, Option<Deserializer<K>> keyDeserializer, Option<Deserializer<V>> valueDeserializer) {
        Map<String, String> properties = ConfigSettings$.MODULE$.parseKafkaClientsProperties(config.getConfig("kafka-clients"));
        Predef$.MODULE$.require(keyDeserializer != null && (keyDeserializer.isDefined() || properties.contains((Object)"key.deserializer")), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Key deserializer should be defined or declared in configuration";
            }
        });
        Predef$.MODULE$.require(valueDeserializer != null && (valueDeserializer.isDefined() || properties.contains((Object)"value.deserializer")), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Value deserializer should be defined or declared in configuration";
            }
        });
        FiniteDuration pollInterval = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("poll-interval")));
        FiniteDuration pollTimeout = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("poll-timeout")));
        FiniteDuration stopTimeout = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("stop-timeout")));
        FiniteDuration closeTimeout = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("close-timeout")));
        FiniteDuration commitTimeout = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("commit-timeout")));
        FiniteDuration commitTimeWarning = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("commit-time-warning")));
        Duration commitRefreshInterval = ConfigSettings$.MODULE$.getPotentiallyInfiniteDuration(config, "commit-refresh-interval");
        String dispatcher = config.getString("use-dispatcher");
        FiniteDuration waitClosePartition = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("wait-close-partition")));
        FiniteDuration positionTimeout = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("position-timeout")));
        FiniteDuration offsetForTimesTimeout = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("offset-for-times-timeout")));
        FiniteDuration metadataRequestTimeout = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("metadata-request-timeout")));
        return new ConsumerSettings<K, V>(properties, keyDeserializer, valueDeserializer, pollInterval, pollTimeout, stopTimeout, closeTimeout, commitTimeout, commitRefreshInterval, dispatcher, commitTimeWarning, waitClosePartition, positionTimeout, offsetForTimesTimeout, metadataRequestTimeout, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Consumer<K, V> apply(ConsumerSettings<K, V> settings) {
                return ConsumerSettings$.MODULE$.createKafkaConsumer(settings);
            }
        });
    }

    public <K, V> ConsumerSettings<K, V> apply(ActorSystem system, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.apply(system, Option$.MODULE$.apply(keyDeserializer), Option$.MODULE$.apply(valueDeserializer));
    }

    public <K, V> ConsumerSettings<K, V> apply(Config config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.apply(config, Option$.MODULE$.apply(keyDeserializer), Option$.MODULE$.apply(valueDeserializer));
    }

    public <K, V> ConsumerSettings<K, V> create(ActorSystem system, Optional<Deserializer<K>> keyDeserializer, Optional<Deserializer<V>> valueDeserializer) {
        return this.apply(system, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(keyDeserializer)), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(valueDeserializer)));
    }

    public <K, V> ConsumerSettings<K, V> create(Config config, Optional<Deserializer<K>> keyDeserializer, Optional<Deserializer<V>> valueDeserializer) {
        return this.apply(config, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(keyDeserializer)), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(valueDeserializer)));
    }

    public <K, V> ConsumerSettings<K, V> create(ActorSystem system, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.apply(system, keyDeserializer, valueDeserializer);
    }

    public <K, V> ConsumerSettings<K, V> create(Config config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.apply(config, keyDeserializer, valueDeserializer);
    }

    public <K, V> Consumer<K, V> createKafkaConsumer(ConsumerSettings<K, V> settings) {
        return new KafkaConsumer(settings.getProperties(), (Deserializer)settings.keyDeserializerOpt().orNull(Predef$.MODULE$.$conforms()), (Deserializer)settings.valueDeserializerOpt().orNull(Predef$.MODULE$.$conforms()));
    }

    private ConsumerSettings$() {
        MODULE$ = this;
        this.configPath = "akka.kafka.consumer";
    }
}

