/*
 * Decompiled with CFR 0.152.
 */
package akka.kafka;

import akka.actor.ActorSystem;
import akka.kafka.ProducerSettings;
import akka.kafka.internal.ConfigSettings$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$DurationOps$;
import com.typesafe.config.Config;
import java.util.Optional;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.Serializer;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.duration.FiniteDuration;

public final class ProducerSettings$ {
    public static final ProducerSettings$ MODULE$;
    private final String configPath;

    static {
        new ProducerSettings$();
    }

    public String configPath() {
        return this.configPath;
    }

    public <K, V> ProducerSettings<K, V> apply(ActorSystem system, Option<Serializer<K>> keySerializer, Option<Serializer<V>> valueSerializer) {
        return this.apply(system.settings().config().getConfig(this.configPath()), keySerializer, valueSerializer);
    }

    public <K, V> ProducerSettings<K, V> apply(Config config, Option<Serializer<K>> keySerializer, Option<Serializer<V>> valueSerializer) {
        Map<String, String> properties = ConfigSettings$.MODULE$.parseKafkaClientsProperties(config.getConfig("kafka-clients"));
        Predef$.MODULE$.require(keySerializer != null && (keySerializer.isDefined() || properties.contains((Object)"key.serializer")), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Key serializer should be defined or declared in configuration";
            }
        });
        Predef$.MODULE$.require(valueSerializer != null && (valueSerializer.isDefined() || properties.contains((Object)"value.serializer")), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Value serializer should be defined or declared in configuration";
            }
        });
        FiniteDuration closeTimeout = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("close-timeout")));
        int parallelism = config.getInt("parallelism");
        String dispatcher = config.getString("use-dispatcher");
        FiniteDuration eosCommitInterval = JavaDurationConverters$DurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.DurationOps(config.getDuration("eos-commit-interval")));
        return new ProducerSettings<K, V>(properties, keySerializer, valueSerializer, closeTimeout, parallelism, dispatcher, eosCommitInterval, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final KafkaProducer<K, V> apply(ProducerSettings<K, V> settings) {
                return ProducerSettings$.MODULE$.createKafkaProducer(settings);
            }
        });
    }

    public <K, V> ProducerSettings<K, V> apply(ActorSystem system, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.apply(system, Option$.MODULE$.apply(keySerializer), Option$.MODULE$.apply(valueSerializer));
    }

    public <K, V> ProducerSettings<K, V> apply(Config config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.apply(config, Option$.MODULE$.apply(keySerializer), Option$.MODULE$.apply(valueSerializer));
    }

    public <K, V> ProducerSettings<K, V> create(ActorSystem system, Optional<Serializer<K>> keySerializer, Optional<Serializer<V>> valueSerializer) {
        return this.apply(system, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(keySerializer)), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(valueSerializer)));
    }

    public <K, V> ProducerSettings<K, V> create(Config config, Optional<Serializer<K>> keySerializer, Optional<Serializer<V>> valueSerializer) {
        return this.apply(config, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(keySerializer)), OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(valueSerializer)));
    }

    public <K, V> ProducerSettings<K, V> create(ActorSystem system, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.apply(system, keySerializer, valueSerializer);
    }

    public <K, V> ProducerSettings<K, V> create(Config config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return this.apply(config, keySerializer, valueSerializer);
    }

    public <K, V> KafkaProducer<K, V> createKafkaProducer(ProducerSettings<K, V> settings) {
        return new KafkaProducer(settings.getProperties(), (Serializer)settings.keySerializerOpt().orNull(Predef$.MODULE$.$conforms()), (Serializer)settings.valueSerializerOpt().orNull(Predef$.MODULE$.$conforms()));
    }

    private ProducerSettings$() {
        MODULE$ = this;
        this.configPath = "akka.kafka.producer";
    }
}

