/*
 * Decompiled with CFR 0.152.
 */
package akka.kafka.scaladsl;

import akka.Done;
import akka.NotUsed;
import akka.kafka.ConsumerMessage;
import akka.kafka.ConsumerSettings;
import akka.kafka.ProducerMessage;
import akka.kafka.ProducerSettings;
import akka.kafka.Subscription;
import akka.kafka.internal.TransactionalProducerStage;
import akka.kafka.internal.TransactionalSource;
import akka.kafka.scaladsl.Consumer;
import akka.stream.ActorAttributes$;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import org.apache.kafka.clients.producer.Producer;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;

public final class Transactional$ {
    public static final Transactional$ MODULE$;

    static {
        new Transactional$();
    }

    public <K, V> Source<ConsumerMessage.TransactionalMessage<K, V>, Consumer.Control> source(ConsumerSettings<K, V> settings, Subscription subscription) {
        return Source$.MODULE$.fromGraph(new TransactionalSource<K, V>(settings, subscription));
    }

    public <K, V> Sink<ProducerMessage.Envelope<K, V, ConsumerMessage.PartitionOffset>, Future<Done>> sink(ProducerSettings<K, V> settings, String transactionalId) {
        return this.flow(settings, transactionalId).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right());
    }

    public <K, V> Flow<ProducerMessage.Envelope<K, V, ConsumerMessage.PartitionOffset>, ProducerMessage.Results<K, V, ConsumerMessage.PartitionOffset>, NotUsed> flow(ProducerSettings<K, V> settings, String transactionalId) {
        Predef$.MODULE$.require(transactionalId != null && transactionalId.length() > 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "You must define a Transactional id.";
            }
        });
        ProducerSettings<K, V> txSettings = settings.withProperties((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"enable.idempotence"), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactional.id"), (Object)transactionalId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.in.flight.requests.per.connection"), (Object)((Object)BoxesRunTime.boxToInteger((int)1)).toString())}));
        Flow flow2 = (Flow)Flow$.MODULE$.fromGraph(new TransactionalProducerStage(txSettings.closeTimeout(), true, new Serializable(txSettings){
            public static final long serialVersionUID = 0L;
            private final ProducerSettings txSettings$1;

            public final Producer<K, V> apply() {
                return this.txSettings$1.createKafkaProducer();
            }
            {
                this.txSettings$1 = txSettings$1;
            }
        }, settings.eosCommitInterval())).mapAsync(txSettings.parallelism(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Future<ProducerMessage.Results<K, V, ConsumerMessage.PartitionOffset>> apply(Future<ProducerMessage.Results<K, V, ConsumerMessage.PartitionOffset>> x) {
                return (Future)Predef$.MODULE$.identity(x);
            }
        });
        return this.flowWithDispatcher(txSettings, flow2);
    }

    private <PassThrough, V, K> Flow<ProducerMessage.Envelope<K, V, PassThrough>, ProducerMessage.Results<K, V, PassThrough>, NotUsed> flowWithDispatcher(ProducerSettings<K, V> settings, Flow<ProducerMessage.Envelope<K, V, PassThrough>, ProducerMessage.Results<K, V, PassThrough>, NotUsed> flow2) {
        return settings.dispatcher().isEmpty() ? flow2 : flow2.withAttributes(ActorAttributes$.MODULE$.dispatcher(settings.dispatcher()));
    }

    private Transactional$() {
        MODULE$ = this;
    }
}

