package com.codacy.tracing.kamon

import com.codacy.tracing.core.Tag
import kamon.Kamon

object Registry {

  def apply(): com.codacy.tracing.core.Registry = {
    new Registry(Kamon)
  }
}

class Registry(private[tracing] val underlying: kamon.Tracing) extends com.codacy.tracing.core.Registry {

  override def buildSpan(name: String, tags: Set[Tag] = Set.empty): SpanBuilder = {
    val builder = tags.foldLeft(underlying.spanBuilder(name)) {
      case (bldr, tag) => bldr.tag(tag.key, tag.value)
    }

    new SpanBuilder(builder)
  }

}
