/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.passpol;

import com.codahale.passpol.HaveIBeenPwned;
import com.codahale.passpol.PasswordSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;

public interface BreachDatabase {
    public boolean contains(String var1) throws IOException;

    public static BreachDatabase haveIBeenPwned() {
        return BreachDatabase.haveIBeenPwned(1);
    }

    public static BreachDatabase haveIBeenPwned(int threshold) {
        return BreachDatabase.haveIBeenPwned(HttpClient.newHttpClient(), threshold);
    }

    public static BreachDatabase haveIBeenPwned(HttpClient client, int threshold) {
        return new HaveIBeenPwned(Objects.requireNonNull(client), threshold);
    }

    public static BreachDatabase passwordSet(Collection<String> passwords) {
        return new PasswordSet(Objects.requireNonNull(passwords).stream());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static BreachDatabase top100K() {
        try (InputStream in = BreachDatabase.class.getResourceAsStream("weak-passwords.txt");){
            PasswordSet passwordSet;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                passwordSet = new PasswordSet(r.lines());
            }
            return passwordSet;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static BreachDatabase anyOf(BreachDatabase ... databases) {
        for (BreachDatabase database : databases) {
            Objects.requireNonNull(database);
        }
        return password -> {
            for (BreachDatabase database : databases) {
                if (!database.contains(password)) continue;
                return true;
            }
            return false;
        };
    }
}

