/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.passpol;

import com.codahale.passpol.BreachDatabase;
import com.codahale.passpol.PasswordPolicy;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Stream;

class HaveIBeenPwned
implements BreachDatabase {
    private static final int HASH_LENGTH = 40;
    private static final int PREFIX_LENGTH = 5;
    private static final int SUFFIX_LENGTH = 35;
    private static final int DELIM_LENGTH = 1;
    private static final URI BASE_URI = URI.create("https://api.pwnedpasswords.com/range/");
    private final HttpClient client;
    private final int threshold;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    HaveIBeenPwned(HttpClient client, int threshold) {
        this.client = client;
        this.threshold = threshold;
    }

    @Override
    public boolean contains(String password) throws IOException {
        try {
            String hash = HaveIBeenPwned.hex(MessageDigest.getInstance("SHA1").digest(PasswordPolicy.normalize(password)));
            HttpRequest request = HttpRequest.newBuilder().GET().uri(BASE_URI.resolve(hash.substring(0, 5))).header("User-Agent", "passpol").build();
            HttpResponse<Stream<String>> response = this.client.send(request, HttpResponse.BodyHandlers.ofLines());
            if (response.statusCode() != 200) {
                throw new IOException("Unexpected response from server: " + response.statusCode());
            }
            return response.body().filter(s -> s.regionMatches(0, hash, 5, 35)).map(s -> s.substring(41)).mapToInt(Integer::parseInt).anyMatch(t -> t >= this.threshold);
        }
        catch (IndexOutOfBoundsException | InterruptedException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static String hex(byte[] bytes) {
        StringBuilder b = new StringBuilder(40);
        for (byte v : bytes) {
            b.append(HEX[(v & 0xFF) >> 4]);
            b.append(HEX[v & 0xF]);
        }
        return b.toString();
    }
}

