/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.passpol;

import com.codahale.passpol.BreachDatabase;
import com.codahale.passpol.PasswordSet;
import com.codahale.passpol.Status;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class PasswordPolicy {
    public static final int RECOMMENDED_MIN_LENGTH = 8;
    public static final int RECOMMENDED_MAX_LENGTH = 64;
    private final int minLength;
    private final int maxLength;
    private final BreachDatabase breachDatabase;

    public PasswordPolicy() {
        this(BreachDatabase.top100K(), 8, 64);
    }

    public PasswordPolicy(BreachDatabase breachDatabase, int minLength, int maxLength) {
        if (maxLength < minLength) {
            throw new IllegalArgumentException("minLength must be less than maxLength");
        }
        this.breachDatabase = breachDatabase;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public static byte[] normalize(String password) {
        return PasswordSet.normalize(Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8);
    }

    public Status check(String password) {
        int len = Objects.requireNonNull(password).codePointCount(0, password.length());
        if (len < this.minLength) {
            return Status.TOO_SHORT;
        }
        if (len > this.maxLength) {
            return Status.TOO_LONG;
        }
        try {
            if (this.breachDatabase.contains(password)) {
                return Status.BREACHED;
            }
        }
        catch (IOException e) {
            return Status.OK;
        }
        return Status.OK;
    }
}

