/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.passpol;

import com.codahale.passpol.BreachDatabase;
import java.text.Normalizer;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class PasswordSet
implements BreachDatabase {
    private final Set<String> passwords;

    PasswordSet(Stream<String> passwords) {
        this.passwords = passwords.map(PasswordSet::normalize).collect(Collectors.toUnmodifiableSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PasswordSet)) {
            return false;
        }
        PasswordSet that = (PasswordSet)o;
        return Objects.equals(this.passwords, that.passwords);
    }

    public int hashCode() {
        return Objects.hash(this.passwords);
    }

    public String toString() {
        return this.passwords.toString();
    }

    @Override
    public boolean contains(String password) {
        return this.passwords.contains(PasswordSet.normalize(password));
    }

    static String normalize(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFKC);
    }
}

