/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.shamir;

import com.codahale.shamir.GF256;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class Scheme {
    private final SecureRandom random;
    private final int n;
    private final int k;

    public Scheme(SecureRandom random, int n, int k) {
        this.random = random;
        Scheme.checkArgument(k > 1, "K must be > 1");
        Scheme.checkArgument(n >= k, "N must be >= K");
        Scheme.checkArgument(n <= 255, "N must be <= 255");
        this.n = n;
        this.k = k;
    }

    public Map<Integer, byte[]> split(byte[] secret) {
        byte[][] values = new byte[this.n][secret.length];
        for (int i = 0; i < secret.length; ++i) {
            byte[] p = GF256.generate(this.random, this.k - 1, secret[i]);
            for (int x = 1; x <= this.n; ++x) {
                values[x - 1][i] = GF256.eval(p, (byte)x);
            }
        }
        HashMap<Integer, byte[]> parts = new HashMap<Integer, byte[]>(this.n());
        for (int i = 0; i < values.length; ++i) {
            parts.put(i + 1, values[i]);
        }
        return Collections.unmodifiableMap(parts);
    }

    public byte[] join(Map<Integer, byte[]> parts) {
        Scheme.checkArgument(parts.size() > 0, "No parts provided");
        int[] lengths = parts.values().stream().mapToInt(v -> ((byte[])v).length).distinct().toArray();
        Scheme.checkArgument(lengths.length == 1, "Varying lengths of part values");
        byte[] secret = new byte[lengths[0]];
        for (int i = 0; i < secret.length; ++i) {
            byte[][] points = new byte[parts.size()][2];
            int j = 0;
            for (Map.Entry<Integer, byte[]> part : parts.entrySet()) {
                points[j][0] = part.getKey().byteValue();
                points[j][1] = part.getValue()[i];
                ++j;
            }
            secret[i] = GF256.interpolate(points);
        }
        return secret;
    }

    public int n() {
        return this.n;
    }

    public int k() {
        return this.k;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scheme scheme = (Scheme)o;
        return this.n == scheme.n && this.k == scheme.k && Objects.equals(this.random, scheme.random);
    }

    public int hashCode() {
        return Objects.hash(this.random, this.n, this.k);
    }

    public String toString() {
        return new StringJoiner(", ", Scheme.class.getSimpleName() + "[", "]").add("random=" + this.random).add("n=" + this.n).add("k=" + this.k).toString();
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

