/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.timeid;

import com.codahale.timeid.PRNG;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;

public class IdGenerator
implements Externalizable {
    public static final String MIN_VALUE = "$$$$$$$$$$$$$$$$$$$$$$$$$$$";
    public static final String MAX_VALUE = "zzzzzzzzzzzzzzzzzzzzzzzzzzz";
    private static final char[] ALPHABET = "$0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final long EPOCH_OFFSET = 1400000000L;
    private static final long serialVersionUID = 5133358267293287137L;
    private final Clock clock;
    private final byte[] id;
    private final char[] out;
    private final PRNG prng;

    public IdGenerator() {
        this(new SecureRandom(), Clock.systemUTC());
    }

    IdGenerator(SecureRandom random, Clock clock) {
        this.clock = clock;
        this.id = new byte[21];
        this.out = new char[28];
        this.prng = new PRNG(random);
    }

    public synchronized String generate() {
        int timestamp = (int)(this.clock.millis() / 1000L - 1400000000L);
        this.id[0] = (byte)(timestamp >> 24);
        this.id[1] = (byte)(timestamp >> 16);
        this.id[2] = (byte)(timestamp >> 8);
        this.id[3] = (byte)timestamp;
        this.prng.append(this.id);
        return this.encode(this.id);
    }

    public static Instant createdAt(String id) {
        int timestamp = (Arrays.binarySearch(ALPHABET, id.charAt(0)) << 26) + (Arrays.binarySearch(ALPHABET, id.charAt(1)) << 20) + (Arrays.binarySearch(ALPHABET, id.charAt(2)) << 14) + (Arrays.binarySearch(ALPHABET, id.charAt(3)) << 8) + (Arrays.binarySearch(ALPHABET, id.charAt(4)) << 2) + (Arrays.binarySearch(ALPHABET, id.charAt(5)) >> 4);
        return Instant.ofEpochMilli(((long)timestamp + 1400000000L) * 1000L);
    }

    private String encode(byte[] b) {
        int i = 0;
        int j = 0;
        while (i < b.length - 1) {
            int v = Byte.toUnsignedInt(b[i++]) << 16 | Byte.toUnsignedInt(b[i++]) << 8 | Byte.toUnsignedInt(b[i++]);
            this.out[j++] = ALPHABET[v >> 18 & 0x3F];
            this.out[j++] = ALPHABET[v >> 12 & 0x3F];
            this.out[j++] = ALPHABET[v >> 6 & 0x3F];
            this.out[j++] = ALPHABET[v & 0x3F];
        }
        return new String(this.out, 0, 27);
    }

    @Override
    public void writeExternal(ObjectOutput out) {
    }

    @Override
    public void readExternal(ObjectInput in) {
    }
}

