/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.timeid;

import java.security.SecureRandom;

class PRNG {
    private static final int SIGMA0 = 1634760805;
    private static final int SIGMA1 = 857760878;
    private static final int SIGMA2 = 2036477234;
    private static final int SIGMA3 = 1797285236;
    private int k0;
    private int k1;
    private int k2;
    private int k3;
    private int k4;
    private int k5;
    private int k6;
    private int k7;

    PRNG(SecureRandom random) {
        this.k0 = random.nextInt();
        this.k1 = random.nextInt();
        this.k2 = random.nextInt();
        this.k3 = random.nextInt();
        this.k4 = random.nextInt();
        this.k5 = random.nextInt();
        this.k6 = random.nextInt();
        this.k7 = random.nextInt();
    }

    void append(byte[] b) {
        int x00 = 1634760805;
        int x01 = 857760878;
        int x02 = 2036477234;
        int x03 = 1797285236;
        int x04 = this.k0;
        int x05 = this.k1;
        int x06 = this.k2;
        int x07 = this.k3;
        int x08 = this.k4;
        int x09 = this.k5;
        int x10 = this.k6;
        int x11 = this.k7;
        int x12 = 1;
        int x13 = 0;
        int x14 = 0;
        int x15 = 0;
        for (int round = 0; round < 10; ++round) {
            x12 = Integer.rotateLeft(x12 ^ (x00 += x04), 16);
            x04 = Integer.rotateLeft(x04 ^ (x08 += x12), 12);
            x12 = Integer.rotateLeft(x12 ^ (x00 += x04), 8);
            x04 = Integer.rotateLeft(x04 ^ (x08 += x12), 7);
            x13 = Integer.rotateLeft(x13 ^ (x01 += x05), 16);
            x05 = Integer.rotateLeft(x05 ^ (x09 += x13), 12);
            x13 = Integer.rotateLeft(x13 ^ (x01 += x05), 8);
            x05 = Integer.rotateLeft(x05 ^ (x09 += x13), 7);
            x14 = Integer.rotateLeft(x14 ^ (x02 += x06), 16);
            x06 = Integer.rotateLeft(x06 ^ (x10 += x14), 12);
            x14 = Integer.rotateLeft(x14 ^ (x02 += x06), 8);
            x06 = Integer.rotateLeft(x06 ^ (x10 += x14), 7);
            x15 = Integer.rotateLeft(x15 ^ (x03 += x07), 16);
            x07 = Integer.rotateLeft(x07 ^ (x11 += x15), 12);
            x15 = Integer.rotateLeft(x15 ^ (x03 += x07), 8);
            x07 = Integer.rotateLeft(x07 ^ (x11 += x15), 7);
            x15 = Integer.rotateLeft(x15 ^ (x00 += x05), 16);
            x05 = Integer.rotateLeft(x05 ^ (x10 += x15), 12);
            x15 = Integer.rotateLeft(x15 ^ (x00 += x05), 8);
            x05 = Integer.rotateLeft(x05 ^ (x10 += x15), 7);
            x12 = Integer.rotateLeft(x12 ^ (x01 += x06), 16);
            x06 = Integer.rotateLeft(x06 ^ (x11 += x12), 12);
            x12 = Integer.rotateLeft(x12 ^ (x01 += x06), 8);
            x06 = Integer.rotateLeft(x06 ^ (x11 += x12), 7);
            x13 = Integer.rotateLeft(x13 ^ (x02 += x07), 16);
            x07 = Integer.rotateLeft(x07 ^ (x08 += x13), 12);
            x13 = Integer.rotateLeft(x13 ^ (x02 += x07), 8);
            x07 = Integer.rotateLeft(x07 ^ (x08 += x13), 7);
            x14 = Integer.rotateLeft(x14 ^ (x03 += x04), 16);
            x04 = Integer.rotateLeft(x04 ^ (x09 += x14), 12);
            x14 = Integer.rotateLeft(x14 ^ (x03 += x04), 8);
            x04 = Integer.rotateLeft(x04 ^ (x09 += x14), 7);
        }
        PRNG.littleEndian(x08 + this.k4, b, 4);
        PRNG.littleEndian(x09 + this.k5, b, 8);
        PRNG.littleEndian(x10 + this.k6, b, 12);
        PRNG.littleEndian(x11 + this.k7, b, 16);
        this.k4 = x04 + this.k0;
        this.k5 = x05 + this.k1;
        this.k6 = x06 + this.k2;
        this.k7 = x07 + this.k3;
        this.k0 = x00 + 1634760805;
        this.k1 = x01 + 857760878;
        this.k2 = x02 + 2036477234;
        this.k3 = x03 + 1797285236;
    }

    private static void littleEndian(int v, byte[] b, int pos) {
        b[pos++] = (byte)v;
        b[pos++] = (byte)(v >> 8);
        b[pos++] = (byte)(v >> 16);
        b[pos] = (byte)(v >> 24);
    }
}

