/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.api;

import com.code_intelligence.jazzer.api.SilentCloseable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;

public final class BugDetectors {
    private static final AtomicReference<BiPredicate<String, Integer>> currentPolicy = BugDetectors.getConnectionPermittedReference();

    public static SilentCloseable allowNetworkConnections() {
        return BugDetectors.allowNetworkConnections((host, port) -> true);
    }

    public static SilentCloseable allowNetworkConnections(BiPredicate<String, Integer> connectionPermitted) {
        if (connectionPermitted == null) {
            throw new IllegalArgumentException("connectionPermitted must not be null");
        }
        if (currentPolicy == null) {
            throw new IllegalStateException("Failed to set network connection policy");
        }
        BiPredicate<String, Integer> previousPolicy = currentPolicy.getAndSet(connectionPermitted);
        return () -> {
            if (!currentPolicy.compareAndSet(connectionPermitted, previousPolicy)) {
                throw new IllegalStateException("Failed to reset network connection policy - using try-with-resources is highly recommended");
            }
        };
    }

    private static AtomicReference<BiPredicate<String, Integer>> getConnectionPermittedReference() {
        try {
            Class<?> ssrfSanitizer = Class.forName("com.code_intelligence.jazzer.sanitizers.ServerSideRequestForgery");
            return (AtomicReference)ssrfSanitizer.getField("connectionPermitted").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            System.err.println("WARNING: ");
            e.printStackTrace();
            return null;
        }
    }

    private BugDetectors() {
    }
}

