/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public interface FuzzedDataProvider {
    public boolean consumeBoolean();

    public boolean[] consumeBooleans(int var1);

    public byte consumeByte();

    public byte consumeByte(byte var1, byte var2);

    public byte[] consumeBytes(int var1);

    public byte[] consumeRemainingAsBytes();

    public short consumeShort();

    public short consumeShort(short var1, short var2);

    public short[] consumeShorts(int var1);

    public int consumeInt();

    public int consumeInt(int var1, int var2);

    public int[] consumeInts(int var1);

    public long consumeLong();

    public long consumeLong(long var1, long var3);

    public long[] consumeLongs(int var1);

    public float consumeFloat();

    public float consumeRegularFloat();

    public float consumeRegularFloat(float var1, float var2);

    public float consumeProbabilityFloat();

    public double consumeDouble();

    public double consumeRegularDouble();

    public double consumeRegularDouble(double var1, double var3);

    public double consumeProbabilityDouble();

    public char consumeChar();

    public char consumeChar(char var1, char var2);

    public char consumeCharNoSurrogates();

    public String consumeString(int var1);

    public String consumeRemainingAsString();

    public String consumeAsciiString(int var1);

    public String consumeRemainingAsAsciiString();

    public int remainingBytes();

    default public <T> T pickValue(Collection<T> collection) {
        int size = collection.size();
        if (size == 0) {
            throw new IllegalArgumentException("collection is empty");
        }
        if (collection instanceof List) {
            return (T)((List)collection).get(this.consumeInt(0, size - 1));
        }
        return (T)this.pickValue(collection.toArray());
    }

    default public <T> T pickValue(T[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public boolean pickValue(boolean[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public byte pickValue(byte[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public short pickValue(short[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public int pickValue(int[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public long pickValue(long[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public double pickValue(double[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public float pickValue(float[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public char pickValue(char[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return array[this.consumeInt(0, array.length - 1)];
    }

    default public <T> List<T> pickValues(Collection<T> collection, int numOfElements) {
        int size = collection.size();
        if (size == 0) {
            throw new IllegalArgumentException("collection is empty");
        }
        if (numOfElements > collection.size()) {
            throw new IllegalArgumentException("numOfElements exceeds collection.size()");
        }
        ArrayList<T> remainingElements = new ArrayList<T>(collection);
        ArrayList<T> pickedElements = new ArrayList<T>();
        for (int i = 0; i < numOfElements; ++i) {
            T element = this.pickValue(remainingElements);
            pickedElements.add(element);
            remainingElements.remove(element);
        }
        return pickedElements;
    }

    default public <T> List<T> pickValues(T[] array, int numOfElements) {
        if (array.length == 0) {
            throw new IllegalArgumentException("array is empty");
        }
        return this.pickValues(Arrays.asList(array), numOfElements);
    }
}

