/*
 * Copyright 2024 Code Intelligence GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.code_intelligence.jazzer.mutation.utils;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The scope of Jazzer annotations can be configured using the constants defined in this
 * meta-annotations. <br>
 * Annotations supporting property constraints need to be marked with this meta-annotation and
 * contain a {@link java.lang.String} property named "constrained", referencing the constants
 * defined in this class.
 */
@Target(ANNOTATION_TYPE)
@Retention(RUNTIME)
public @interface PropertyConstraint {

  /** Annotations restricted with {@code DECLARATION} only apply to the annotated type. */
  String DECLARATION = "JAZZER_PROPERTY_CONSTRAINT_DECLARATION";

  /**
   * Annotations restricted with {@code RECURSIVE} apply to the annotated type, and recursively to
   * all types of components of the annotated one.
   */
  String RECURSIVE = "JAZZER_PROPERTY_CONSTRAINT_RECURSIVE";
}
