/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.api;

import com.code_intelligence.jazzer.api.SilentCloseable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class BugDetectors {
    private static final AtomicReference<BiPredicate<String, Integer>> currentPolicy = BugDetectors.getSanitizerVariable("com.code_intelligence.jazzer.sanitizers.ServerSideRequestForgery", "connectionPermitted");
    private static final AtomicReference<Supplier<Path>> currentPathTraversalTarget = BugDetectors.getSanitizerVariable("com.code_intelligence.jazzer.sanitizers.FilePathTraversal", "target");
    private static final AtomicReference<Predicate<Path>> currentCheckPath = BugDetectors.getSanitizerVariable("com.code_intelligence.jazzer.sanitizers.FilePathTraversal", "checkPath");

    public static SilentCloseable allowNetworkConnections() {
        return BugDetectors.allowNetworkConnections((host, port) -> true);
    }

    public static SilentCloseable allowNetworkConnections(BiPredicate<String, Integer> connectionPermitted) {
        return BugDetectors.setSanitizerVariable(connectionPermitted, currentPolicy);
    }

    public static SilentCloseable setFilePathTraversalTarget(Supplier<Path> pathTraversalTarget) {
        return BugDetectors.setSanitizerVariable(pathTraversalTarget, currentPathTraversalTarget);
    }

    public static SilentCloseable setFilePathTraversalAllowPath(Predicate<Path> checkPath) {
        return BugDetectors.setSanitizerVariable(checkPath, currentCheckPath);
    }

    private static <T> AtomicReference<T> getSanitizerVariable(String sanitizerClassName, String fieldName) {
        try {
            return (AtomicReference)Class.forName(sanitizerClassName).getField(fieldName).get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            System.err.println("WARN: ");
            e.printStackTrace();
            return null;
        }
    }

    private static <T> SilentCloseable setSanitizerVariable(T newValue, AtomicReference<T> currentValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("sanitizer variable must not be null");
        }
        if (currentValue == null) {
            throw new IllegalStateException("Failed to set sanitizer variable");
        }
        Object previousValue = currentValue.getAndSet(newValue);
        return () -> {
            if (!currentValue.compareAndSet(newValue, previousValue)) {
                throw new IllegalStateException("Failed to reset sanitizer variable - using try-with-resources is highly recommended");
            }
        };
    }

    private BugDetectors() {
    }
}

