/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.junit.Utils;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.extension.ExtensionContext;

class AgentConfigurator {
    private static final AtomicBoolean hasBeenConfigured = new AtomicBoolean();

    AgentConfigurator() {
    }

    static void forRegressionTest(ExtensionContext extensionContext) {
        if (!hasBeenConfigured.compareAndSet(false, true)) {
            return;
        }
        AgentConfigurator.applyCommonConfiguration();
        System.setProperty("jazzer.internal.conditional_hooks", "true");
        System.setProperty("jazzer.instrumentation_excludes", "**");
        extensionContext.getConfigurationParameter("jazzer.instrument").ifPresent(s -> System.setProperty("jazzer.custom_hook_includes", String.join((CharSequence)File.pathSeparator, s.split(","))));
    }

    static void forFuzzing(ExtensionContext executionRequest) {
        if (!hasBeenConfigured.compareAndSet(false, true)) {
            throw new IllegalStateException("Only a single fuzz test should be executed per fuzzing run");
        }
        AgentConfigurator.applyCommonConfiguration();
        String instrumentationFilter = executionRequest.getConfigurationParameter("jazzer.instrument").orElseGet(() -> Utils.defaultInstrumentationFilter(executionRequest.getRequiredTestClass()));
        String filter = String.join((CharSequence)File.pathSeparator, instrumentationFilter.split(","));
        System.setProperty("jazzer.custom_hook_includes", filter);
        System.setProperty("jazzer.instrumentation_includes", filter);
    }

    private static void applyCommonConfiguration() {
        System.setProperty("jazzer.custom_hook_excludes", String.join((CharSequence)File.pathSeparator, "com.google.testing.junit.**", "com.intellij.**", "io.github.classgraph.**", "junit.framework.**", "net.bytebuddy.**", "org.apiguardian.**", "org.assertj.core.**", "org.hamcrest.**", "org.junit.**", "org.opentest4j.**", "org.apache.maven.**", "org.gradle.**"));
    }
}

