/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.driver.FuzzTargetHolder;
import com.code_intelligence.jazzer.driver.FuzzTargetRunner;
import com.code_intelligence.jazzer.driver.junit.ExitCodeException;
import com.code_intelligence.jazzer.junit.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

abstract class FuzzTestExecutor {
    private static final AtomicBoolean hasBeenPrepared = new AtomicBoolean();

    FuzzTestExecutor() {
    }

    public static FuzzTestExecutor prepare(ExtensionContext context, String maxDuration) throws IOException {
        if (!hasBeenPrepared.compareAndSet(false, true)) {
            throw new IllegalStateException("FuzzTestExecutor#prepare can only be called once per test run");
        }
        Method fuzzTestMethod = context.getRequiredTestMethod();
        if (fuzzTestMethod.getParameterCount() == 0) {
            throw new IllegalArgumentException("Methods annotated with @FuzzTest must take at least one parameter");
        }
        if (FuzzTestExecutor.useAutofuzz(fuzzTestMethod)) {
            System.setProperty("jazzer.autofuzz", String.format("%s::%s%s", fuzzTestMethod.getDeclaringClass().getName(), fuzzTestMethod.getName(), com.code_intelligence.jazzer.utils.Utils.getReadableDescriptor((Executable)fuzzTestMethod)));
        }
        if (Utils.runFromCommandLine(context)) {
            return FuzzTestExecutor.prepareForCommandLine(context);
        }
        return FuzzTestExecutor.prepareForTestRunner(context, maxDuration);
    }

    private static FuzzTestExecutor prepareForCommandLine(ExtensionContext context) {
        return new CommandLineFuzzTestExecutor(context);
    }

    private static FuzzTestExecutor prepareForTestRunner(ExtensionContext context, String maxDuration) throws IOException {
        Optional<Path> inputsDirectory;
        URL inputsDirectoryUrl;
        Path baseDir = Paths.get(context.getConfigurationParameter("jazzer.internal.basedir").orElse(""), new String[0]).toAbsolutePath();
        Class fuzzTestClass = context.getRequiredTestClass();
        ArrayList<String> libFuzzerArgs = new ArrayList<String>();
        libFuzzerArgs.add("fake_argv0");
        Path generatedCorpusDir = baseDir.resolve(Utils.generatedCorpusPath(fuzzTestClass));
        Files.createDirectories(generatedCorpusDir, new FileAttribute[0]);
        libFuzzerArgs.add(generatedCorpusDir.toAbsolutePath().toString());
        Optional<Path> findingsDirectory = Utils.inputsDirectorySourcePath(fuzzTestClass, baseDir);
        if (!findingsDirectory.isPresent()) {
            context.publishReportEntry(String.format("Collecting crashing inputs in the project root directory.\nIf you want to keep them organized by fuzz test and automatically run them as regression tests with JUnit Jupiter, create a test resource directory called '%s' in package '%s' and move the files there.", Utils.inputsDirectoryResourcePath(fuzzTestClass), fuzzTestClass.getPackage().getName()));
        }
        if ((inputsDirectoryUrl = fuzzTestClass.getResource(Utils.inputsDirectoryResourcePath(fuzzTestClass))) != null && "file".equals(inputsDirectoryUrl.getProtocol())) {
            try {
                inputsDirectory = Optional.of(Paths.get(inputsDirectoryUrl.toURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (inputsDirectoryUrl != null && !findingsDirectory.isPresent()) {
                context.publishReportEntry("When running Jazzer fuzz tests from a JAR rather than class files, the inputs directory isn't used unless it is located under src/test/resources/...");
            }
            inputsDirectory = findingsDirectory;
        }
        inputsDirectory.ifPresent(dir -> libFuzzerArgs.add(dir.toAbsolutePath().toString()));
        libFuzzerArgs.add(String.format("-artifact_prefix=%s%c", findingsDirectory.orElse(baseDir).toAbsolutePath(), Character.valueOf(File.separatorChar)));
        libFuzzerArgs.add("-max_total_time=" + FuzzTestExecutor.durationStringToSeconds(maxDuration));
        libFuzzerArgs.add("-rss_limit_mb=0");
        if (Utils.permissivelyParseBoolean(context.getConfigurationParameter("jazzer.valueprofile").orElse("false"))) {
            libFuzzerArgs.add("-use_value_profile=1");
        }
        return new TestRunnerFuzzTestExecutor(libFuzzerArgs);
    }

    static long durationStringToSeconds(String duration) {
        String isoDuration = "PT" + duration.replace("sec", "s").replace("min", "m").replace("hr", "h").replace(" ", "");
        return Duration.parse(isoDuration).getSeconds();
    }

    private static boolean useAutofuzz(Method fuzzTestMethod) {
        return fuzzTestMethod.getParameterCount() != 1 || fuzzTestMethod.getParameterTypes()[0] != byte[].class && fuzzTestMethod.getParameterTypes()[0] != FuzzedDataProvider.class;
    }

    public abstract Optional<Throwable> executeInternal(ReflectiveInvocationContext<Method> var1);

    public Optional<Throwable> execute(ReflectiveInvocationContext<Method> invocationContext) {
        FuzzTargetHolder.fuzzTarget = FuzzTestExecutor.useAutofuzz((Method)invocationContext.getExecutable()) ? FuzzTargetHolder.AUTOFUZZ_FUZZ_TARGET : new FuzzTargetHolder.FuzzTarget((Method)invocationContext.getExecutable(), () -> invocationContext.getTarget().get(), Optional.empty());
        return this.executeInternal(invocationContext);
    }

    private static final class TestRunnerFuzzTestExecutor
    extends FuzzTestExecutor {
        private final List<String> libFuzzerArgs;

        private TestRunnerFuzzTestExecutor(List<String> libFuzzerArgs) {
            this.libFuzzerArgs = libFuzzerArgs;
        }

        @Override
        public Optional<Throwable> executeInternal(ReflectiveInvocationContext<Method> invocationContext) {
            AtomicReference atomicFinding = new AtomicReference();
            FuzzTargetRunner.registerFindingHandler(t -> {
                atomicFinding.set(t);
                return false;
            });
            int exitCode = FuzzTargetRunner.startLibFuzzer(this.libFuzzerArgs);
            Throwable finding = (Throwable)atomicFinding.get();
            if (finding != null) {
                return Optional.of(finding);
            }
            if (exitCode != 0) {
                return Optional.of(new IllegalStateException("Jazzer exited with exit code " + exitCode));
            }
            return Optional.empty();
        }
    }

    private static final class CommandLineFuzzTestExecutor
    extends FuzzTestExecutor {
        private final List<String> libFuzzerArgs;

        private CommandLineFuzzTestExecutor(ExtensionContext extensionContext) {
            this.libFuzzerArgs = CommandLineFuzzTestExecutor.getLibFuzzerArgs(extensionContext);
        }

        private static List<String> getLibFuzzerArgs(ExtensionContext extensionContext) {
            Optional arg;
            ArrayList<String> args = new ArrayList<String>();
            int i = 0;
            while ((arg = extensionContext.getConfigurationParameter("jazzer.internal.arg." + i)).isPresent()) {
                args.add((String)arg.get());
                ++i;
            }
            return Collections.unmodifiableList(args);
        }

        @Override
        public Optional<Throwable> executeInternal(ReflectiveInvocationContext<Method> invocationContext) {
            int exitCode = FuzzTargetRunner.startLibFuzzer(this.libFuzzerArgs);
            if (exitCode != 0) {
                return Optional.of(new ExitCodeException(exitCode));
            }
            return Optional.empty();
        }
    }
}

