/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.agent.AgentInstaller;
import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.autofuzz.Meta;
import com.code_intelligence.jazzer.driver.FuzzedDataProviderImpl;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.junit.AgentConfigurator;
import com.code_intelligence.jazzer.junit.FuzzTest;
import com.code_intelligence.jazzer.junit.FuzzTestExecutor;
import com.code_intelligence.jazzer.junit.Utils;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

class FuzzTestArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<FuzzTest> {
    private static final String INCORRECT_PARAMETERS_MESSAGE = "Methods annotated with @FuzzTest must take at least one parameter";
    private static final AtomicBoolean agentInstalled = new AtomicBoolean(false);
    private FuzzTest annotation;

    FuzzTestArgumentsProvider() {
    }

    public void accept(FuzzTest annotation) {
        this.annotation = annotation;
    }

    private void configureAndInstallAgent(ExtensionContext extensionContext) throws IOException {
        if (!agentInstalled.compareAndSet(false, true)) {
            return;
        }
        if (Utils.isFuzzing(extensionContext)) {
            FuzzTestExecutor executor = FuzzTestExecutor.prepare(extensionContext, this.annotation.maxDuration());
            extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).put(FuzzTestExecutor.class, (Object)executor);
            AgentConfigurator.forFuzzing(extensionContext);
        } else {
            AgentConfigurator.forRegressionTest(extensionContext);
        }
        AgentInstaller.install((boolean)Opt.hooks);
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) throws IOException {
        Stream<Map.Entry<String, byte[]>> rawSeeds;
        this.configureAndInstallAgent(extensionContext);
        if (Utils.isFuzzing(extensionContext)) {
            rawSeeds = Stream.of(new AbstractMap.SimpleEntry<String, byte[]>("Fuzzing...", new byte[0]));
        } else {
            rawSeeds = Stream.of(new AbstractMap.SimpleEntry<String, byte[]>("<empty input>", new byte[0]));
            Class testClass = extensionContext.getRequiredTestClass();
            rawSeeds = Stream.concat(rawSeeds, this.walkInputs(testClass));
            if (Utils.isCoverageAgentPresent() && Files.isDirectory(Utils.generatedCorpusPath(testClass), new LinkOption[0])) {
                rawSeeds = Stream.concat(rawSeeds, FuzzTestArgumentsProvider.walkInputsInPath(Utils.generatedCorpusPath(testClass)));
            }
        }
        return (Stream)this.adaptInputsForFuzzTest(extensionContext.getRequiredTestMethod(), rawSeeds).onClose(() -> {
            if (!Utils.isFuzzing(extensionContext)) {
                extensionContext.publishReportEntry("No fuzzing has been performed, the fuzz test has only been executed on the fixed set of inputs in the seed corpus.\nTo start fuzzing, run a test with the environment variable JAZZER_FUZZ set to a non-empty value.");
            }
        });
    }

    private Stream<? extends Arguments> adaptInputsForFuzzTest(Method fuzzTestMethod, Stream<Map.Entry<String, byte[]>> rawSeeds) {
        if (fuzzTestMethod.getParameterCount() == 0) {
            throw new IllegalArgumentException(INCORRECT_PARAMETERS_MESSAGE);
        }
        if (fuzzTestMethod.getParameterTypes()[0] == byte[].class) {
            return rawSeeds.map(e -> Arguments.arguments((Object[])new Object[]{Named.named((String)((String)e.getKey()), (Object)((byte[])e.getValue()))}));
        }
        if (fuzzTestMethod.getParameterTypes()[0] == FuzzedDataProvider.class) {
            return rawSeeds.map(e -> Arguments.arguments((Object[])new Object[]{Named.named((String)((String)e.getKey()), (Object)FuzzedDataProviderImpl.withJavaData((byte[])((byte[])e.getValue())))}));
        }
        return rawSeeds.map(e -> {
            try (FuzzedDataProviderImpl data = FuzzedDataProviderImpl.withJavaData((byte[])((byte[])e.getValue()));){
                Meta meta = new Meta(fuzzTestMethod.getDeclaringClass());
                meta.consumeNonStatic((FuzzedDataProvider)data, fuzzTestMethod.getDeclaringClass());
                Object[] args = meta.consumeArguments((FuzzedDataProvider)data, (Executable)fuzzTestMethod, null);
                args[0] = Named.named((String)((String)e.getKey()), (Object)args[0]);
                Arguments arguments = Arguments.arguments((Object[])args);
                return arguments;
            }
        });
    }

    private Stream<Map.Entry<String, byte[]>> walkInputs(Class<?> testClass) throws IOException {
        URI inputsDirUri;
        URL inputsDirUrl = testClass.getResource(Utils.inputsDirectoryResourcePath(testClass));
        if (inputsDirUrl == null) {
            return Stream.empty();
        }
        try {
            inputsDirUri = inputsDirUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to open inputs resource directory: " + inputsDirUrl, e);
        }
        if (inputsDirUri.getScheme().equals("file")) {
            return FuzzTestArgumentsProvider.walkInputsInPath(Paths.get(inputsDirUri));
        }
        if (inputsDirUri.getScheme().equals("jar")) {
            FileSystem jar = FileSystems.newFileSystem(inputsDirUri, new HashMap());
            String pathInJar = inputsDirUrl.getFile().substring(inputsDirUrl.getFile().indexOf(33) + 1);
            return (Stream)FuzzTestArgumentsProvider.walkInputsInPath(jar.getPath(pathInJar, new String[0])).onClose(() -> {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        throw new IOException("Unsupported protocol for inputs resource directory: " + inputsDirUrl);
    }

    private static Stream<Map.Entry<String, byte[]>> walkInputsInPath(Path path) throws IOException {
        return Files.find(path, Integer.MAX_VALUE, (fileOrDir, basicFileAttributes) -> !basicFileAttributes.isDirectory(), FileVisitOption.FOLLOW_LINKS).sorted().map(file -> new AbstractMap.SimpleEntry<String, byte[]>(file.getFileName().toString(), FuzzTestArgumentsProvider.readAllBytesUnchecked(file)));
    }

    private static byte[] readAllBytesUnchecked(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

