/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.junit.FuzzTestExecutor;
import com.code_intelligence.jazzer.junit.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

class FuzzTestExtensions
implements ExecutionCondition,
InvocationInterceptor {
    private static final String JAZZER_INTERNAL = "com.code_intelligence.jazzer.runtime.JazzerInternal";
    private static final AtomicReference<Method> fuzzTestMethod = new AtomicReference();
    private static Field lastFindingField;
    private static Field hooksEnabledField;

    FuzzTestExtensions() {
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (Utils.isFuzzing(extensionContext)) {
            invocation.skip();
            Optional<Throwable> throwable = ((FuzzTestExecutor)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get(FuzzTestExecutor.class, FuzzTestExecutor.class)).execute(invocationContext);
            if (throwable.isPresent()) {
                throw throwable.get();
            }
        } else {
            Throwable thrown = null;
            FuzzTestExtensions.getLastFindingField().set(null, null);
            try (AutoCloseable ignored = FuzzTestExtensions.withHooksEnabled();){
                invocation.proceed();
            }
            catch (Throwable t) {
                thrown = t;
            }
            Throwable stored = (Throwable)FuzzTestExtensions.getLastFindingField().get(null);
            if (stored != null) {
                throw stored;
            }
            if (thrown != null) {
                throw thrown;
            }
        }
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        if (!Utils.isFuzzing(extensionContext)) {
            return ConditionEvaluationResult.enabled((String)"Regression tests are run instead of fuzzing since JAZZER_FUZZ has not been set to a non-empty value");
        }
        if (fuzzTestMethod.compareAndSet(null, extensionContext.getRequiredTestMethod()) || extensionContext.getRequiredTestMethod().equals(fuzzTestMethod.get())) {
            return ConditionEvaluationResult.enabled((String)("Fuzzing " + extensionContext.getRequiredTestMethod()));
        }
        return ConditionEvaluationResult.disabled((String)"Only one fuzz test can be run at a time, but multiple tests have been annotated with @FuzzTest");
    }

    private static Field getLastFindingField() throws ClassNotFoundException, NoSuchFieldException {
        if (lastFindingField == null) {
            Class<?> jazzerInternal = Class.forName(JAZZER_INTERNAL);
            lastFindingField = jazzerInternal.getField("lastFinding");
        }
        return lastFindingField;
    }

    private static Field getHooksEnabledField() throws ClassNotFoundException, NoSuchFieldException {
        if (hooksEnabledField == null) {
            Class<?> jazzerInternal = Class.forName(JAZZER_INTERNAL);
            hooksEnabledField = jazzerInternal.getField("hooksEnabled");
        }
        return hooksEnabledField;
    }

    private static AutoCloseable withHooksEnabled() throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        Field hooksEnabledField = FuzzTestExtensions.getHooksEnabledField();
        hooksEnabledField.setBoolean(null, true);
        return () -> hooksEnabledField.setBoolean(null, false);
    }
}

