/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;

class Utils {
    private static final Pattern COVERAGE_AGENT_ARG = Pattern.compile("-javaagent:.*(?:intellij-coverage-agent|jacoco).*");
    private static final boolean IS_FUZZING_ENV = System.getenv("JAZZER_FUZZ") != null && !System.getenv("JAZZER_FUZZ").isEmpty();

    Utils() {
    }

    static String inputsDirectoryResourcePath(Class<?> testClass) {
        return testClass.getSimpleName() + "Inputs";
    }

    static Optional<Path> inputsDirectorySourcePath(Class<?> testClass, Path baseDir) {
        Path testResourcesDirectory;
        String inputsResourcePath = Utils.inputsDirectoryResourcePath(testClass);
        if (!inputsResourcePath.startsWith("/")) {
            String inputsPackage = testClass.getPackage().getName().replace('.', '/');
            inputsResourcePath = "/" + inputsPackage + "/" + inputsResourcePath;
        }
        Path sourceInputsDirectory = testResourcesDirectory = baseDir.resolve("src").resolve("test").resolve("resources");
        for (String segment : inputsResourcePath.split("/")) {
            sourceInputsDirectory = sourceInputsDirectory.resolve(segment);
        }
        if (Files.isDirectory(sourceInputsDirectory, new LinkOption[0])) {
            return Optional.of(sourceInputsDirectory);
        }
        if (!Files.isDirectory(testResourcesDirectory, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return Optional.of(Files.createDirectories(sourceInputsDirectory, new FileAttribute[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    static Path generatedCorpusPath(Class<?> testClass) {
        return Paths.get(".cifuzz-corpus", testClass.getName());
    }

    static String defaultInstrumentationFilter(Class<?> testClass) {
        String packageName = testClass.getPackage().getName();
        String[] packageSegments = packageName.split("\\.");
        int numSegments = 2;
        if (packageSegments.length > 2 && packageSegments[0].equals("com") && packageSegments[1].equals("github")) {
            numSegments = 3;
        }
        return Stream.concat(Arrays.stream(packageSegments).limit(numSegments), Stream.of("**")).collect(Collectors.joining("."));
    }

    static boolean isCoverageAgentPresent() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(s -> COVERAGE_AGENT_ARG.matcher((CharSequence)s).matches());
    }

    static boolean isFuzzing(ExtensionContext extensionContext) {
        return IS_FUZZING_ENV || Utils.runFromCommandLine(extensionContext);
    }

    static boolean runFromCommandLine(ExtensionContext extensionContext) {
        return extensionContext.getConfigurationParameter("jazzer.internal.commandLine").map(Boolean::parseBoolean).orElse(false);
    }

    static boolean permissivelyParseBoolean(String value) {
        return value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes");
    }

    static long durationStringToSeconds(String duration) {
        String isoDuration = "PT" + duration.replace("sec", "s").replace("min", "m").replace("hr", "h").replace(" ", "");
        return Duration.parse(isoDuration).getSeconds();
    }
}

