/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.junit.DictionaryEntries;
import com.code_intelligence.jazzer.junit.DictionaryFile;
import com.code_intelligence.jazzer.utils.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.platform.commons.support.AnnotationSupport;

class FuzzerDictionary {
    private static final String DICTIONARY_PREFIX = "jazzer-";
    private static final String DICTIONARY_SUFFIX = ".dict";

    FuzzerDictionary() {
    }

    static Optional<Path> createDictionaryFile(Method method) throws IOException {
        List inlineDictionaries = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)method, DictionaryEntries.class);
        List fileDictionaries = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)method, DictionaryFile.class);
        return FuzzerDictionary.createDictionaryFile(inlineDictionaries, fileDictionaries, method.getDeclaringClass());
    }

    private static Optional<Path> createDictionaryFile(List<DictionaryEntries> inline, List<DictionaryFile> files, Class<?> declaringClass) throws IOException {
        int sources = inline.size() + files.size();
        if (sources == 0) {
            return Optional.empty();
        }
        Stream<String> joined = Stream.concat(FuzzerDictionary.getInlineTokens(inline), FuzzerDictionary.getFileTokens(files, declaringClass));
        Path p = Files.createTempFile(DICTIONARY_PREFIX, DICTIONARY_SUFFIX, new FileAttribute[0]);
        p.toFile().deleteOnExit();
        Log.info((String)String.format("Creating merged dictionary from %d sources", sources));
        try (BufferedWriter w = Files.newBufferedWriter(p, StandardCharsets.UTF_8, new OpenOption[0]);){
            joined.forEach(token -> {
                try {
                    w.append((CharSequence)token).append('\n');
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        return Optional.of(p);
    }

    private static Stream<String> getInlineTokens(List<DictionaryEntries> inline) {
        return inline.stream().map(DictionaryEntries::value).flatMap(Arrays::stream).map(FuzzerDictionary::escapeForDictionary);
    }

    static String escapeForDictionary(String rawString) {
        String escapedString = new String(rawString.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1).chars().flatMap(FuzzerDictionary::escapeByteForDictionary).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return '\"' + escapedString + '\"';
    }

    private static IntStream escapeByteForDictionary(int c) {
        if (c == 92) {
            return IntStream.of(92, 92);
        }
        if (c == 34) {
            return IntStream.of(92, 34);
        }
        if (c < 32 && !Character.isWhitespace(c) || c > 127) {
            return IntStream.of(92, 120, Character.toUpperCase(Character.forDigit(c >> 4, 16)), Character.toUpperCase(Character.forDigit(c & 0xF, 16)));
        }
        return IntStream.of(c);
    }

    private static Stream<String> getFileTokens(List<DictionaryFile> files, Class<?> declaringClass) {
        return files.stream().map(DictionaryFile::resourcePath).map(resourcePath -> FuzzerDictionary.tokensFromResource(resourcePath, declaringClass)).flatMap(Collection::stream);
    }

    private static List<String> tokensFromResource(String resourcePath, Class<?> declaringClass) {
        List<String> list;
        block15: {
            InputStream resourceFile = declaringClass.getResourceAsStream(resourcePath);
            try {
                List<String> tokens;
                if (resourceFile == null) {
                    throw new FileNotFoundException(resourcePath);
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceFile));){
                    tokens = reader.lines().collect(Collectors.toList());
                }
                list = tokens;
                if (resourceFile == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceFile != null) {
                        try {
                            resourceFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            resourceFile.close();
        }
        return list;
    }
}

