/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.driver.LifecycleMethodsInvoker;
import com.code_intelligence.jazzer.junit.Lifecycle;
import com.code_intelligence.jazzer.utils.UnsafeProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.DefaultExecutableInvoker;
import org.junit.jupiter.engine.extension.ExtensionRegistry;

final class JUnitLifecycleMethodsInvoker
implements LifecycleMethodsInvoker {
    private final LifecycleMethodsInvoker.ThrowingRunnable testClassInstanceUpdater;
    private final Supplier<Object> testClassInstanceSupplier;
    private final LifecycleMethodsInvoker.ThrowingRunnable[] beforeEachRunnables;
    private final LifecycleMethodsInvoker.ThrowingRunnable[] afterEachRunnables;

    private JUnitLifecycleMethodsInvoker(LifecycleMethodsInvoker.ThrowingRunnable testClassInstanceUpdater, Supplier<Object> testClassInstanceSupplier, LifecycleMethodsInvoker.ThrowingRunnable[] beforeEachRunnables, LifecycleMethodsInvoker.ThrowingRunnable[] afterEachRunnables) {
        this.testClassInstanceUpdater = testClassInstanceUpdater;
        this.testClassInstanceSupplier = testClassInstanceSupplier;
        this.beforeEachRunnables = beforeEachRunnables;
        this.afterEachRunnables = afterEachRunnables;
    }

    static LifecycleMethodsInvoker of(ExtensionContext originalExtensionContext, Lifecycle lifecycleMode) {
        if (lifecycleMode == Lifecycle.PER_TEST) {
            return LifecycleMethodsInvoker.noop((Object)originalExtensionContext.getRequiredTestInstance());
        }
        if (originalExtensionContext.getTestInstances().isPresent() && ((TestInstances)originalExtensionContext.getTestInstances().get()).getAllInstances().size() > 1) {
            throw new IllegalArgumentException("Jazzer does not support nested test classes with LifecycleMode.PER_EXECUTION. Either move your fuzz test to a top-level class or set lifecycle = LifecycleMode.PER_TEST on @FuzzTest.");
        }
        Optional<ExtensionRegistry> maybeExtensionRegistry = JUnitLifecycleMethodsInvoker.getExtensionRegistryViaHack(originalExtensionContext);
        if (!maybeExtensionRegistry.isPresent()) {
            throw new IllegalArgumentException("Jazzer does not support BeforeEach and AfterEach callbacks with this version of JUnit. Either update to at least JUnit 5.9.0 or set lifecycle = LifecycleMode.PER_TEST on @FuzzTest.");
        }
        ExtensionRegistry extensionRegistry = maybeExtensionRegistry.get();
        Object[] mutableTestClassInstance = new Object[]{originalExtensionContext.getRequiredTestInstance()};
        TestInstances testInstances = JUnitLifecycleMethodsInvoker.makeTestInstances(originalExtensionContext.getRequiredTestClass(), () -> mutableTestClassInstance[0]);
        ExtensionContext emptyExtensionContext = (ExtensionContext)Proxy.newProxyInstance(JUnitLifecycleMethodsInvoker.class.getClassLoader(), new Class[]{ExtensionContext.class}, (obj, method, args) -> {
            switch (method.getName()) {
                case "getTestInstance": 
                case "getTestInstances": {
                    return Optional.empty();
                }
                case "getRequiredTestInstance": 
                case "getRequiredTestInstances": {
                    return Optional.empty().get();
                }
            }
            return method.invoke((Object)originalExtensionContext, args);
        });
        ExtensionContext updatingExtensionContext = (ExtensionContext)Proxy.newProxyInstance(JUnitLifecycleMethodsInvoker.class.getClassLoader(), new Class[]{ExtensionContext.class}, (obj, method, args) -> {
            switch (method.getName()) {
                case "getTestInstance": {
                    return Optional.of(mutableTestClassInstance[0]);
                }
                case "getRequiredTestInstance": {
                    return mutableTestClassInstance[0];
                }
                case "getTestInstances": {
                    return Optional.of(testInstances);
                }
                case "getRequiredTestInstances": {
                    return testInstances;
                }
            }
            return method.invoke((Object)originalExtensionContext, args);
        });
        LifecycleMethodsInvoker.ThrowingRunnable[] beforeEachMethods = (LifecycleMethodsInvoker.ThrowingRunnable[])Stream.concat(extensionRegistry.stream(BeforeEachCallback.class).map(callback -> () -> callback.beforeEach(updatingExtensionContext)), extensionRegistry.stream(BeforeEachMethodAdapter.class).map(callback -> () -> callback.invokeBeforeEachMethod(updatingExtensionContext, extensionRegistry))).toArray(LifecycleMethodsInvoker.ThrowingRunnable[]::new);
        ArrayList afterEachMethods = Stream.concat(extensionRegistry.stream(AfterEachCallback.class).map(callback -> () -> callback.afterEach(updatingExtensionContext)), extensionRegistry.stream(AfterEachMethodAdapter.class).map(callback -> () -> callback.invokeAfterEachMethod(updatingExtensionContext, extensionRegistry))).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(afterEachMethods);
        Constructor<?> constructor = JUnitLifecycleMethodsInvoker.getTestClassNoArgsConstructor(updatingExtensionContext);
        ThrowingConsumer[] instancePostProcessors = (ThrowingConsumer[])extensionRegistry.stream(TestInstancePostProcessor.class).map(processor -> instance -> processor.postProcessTestInstance(instance, emptyExtensionContext)).toArray(ThrowingConsumer[]::new);
        LifecycleMethodsInvoker.ThrowingRunnable updateTestClassInstance = () -> {
            Object instance = constructor.newInstance(new Object[0]);
            for (ThrowingConsumer instancePostProcessor : instancePostProcessors) {
                instancePostProcessor.accept(instance);
            }
            mutableTestClassInstance[0] = instance;
        };
        return new JUnitLifecycleMethodsInvoker(updateTestClassInstance, () -> mutableTestClassInstance[0], beforeEachMethods, afterEachMethods.toArray(new LifecycleMethodsInvoker.ThrowingRunnable[0]));
    }

    private static TestInstances makeTestInstances(final Class<?> clazz, final Supplier<Object> singleTestInstance) {
        return new TestInstances(){

            public Object getInnermostInstance() {
                return singleTestInstance.get();
            }

            public List<Object> getEnclosingInstances() {
                return Collections.emptyList();
            }

            public List<Object> getAllInstances() {
                return Collections.singletonList(singleTestInstance.get());
            }

            public <T> Optional<T> findInstance(Class<T> aClass) {
                if (clazz == aClass) {
                    return Optional.of(singleTestInstance.get());
                }
                return Optional.empty();
            }
        };
    }

    private static Constructor<?> getTestClassNoArgsConstructor(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        if (testClass.getEnclosingClass() != null) {
            throw new IllegalArgumentException(String.format("The test class %s is an inner class, which is not supported with LifecycleMode.PER_EXECUTION. Either make it a top-level class or set lifecycle = LifecycleMode.PER_TEST on @FuzzTest.", testClass.getName()));
        }
        try {
            Constructor constructor = testClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("The test class %s has no default constructor, which is not supported with LifecycleMode.PER_EXECUTION. Either add such a constructor or set lifecycle = LifecycleMode.PER_TEST on @FuzzTest.", testClass.getName()));
        }
    }

    private static Optional<ExtensionRegistry> getExtensionRegistryViaHack(ExtensionContext extensionContext) {
        try {
            Class.forName("org.junit.jupiter.engine.execution.DefaultExecutableInvoker");
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
        return Arrays.stream(DefaultExecutableInvoker.class.getDeclaredFields()).filter(field -> field.getType() == ExtensionRegistry.class).findFirst().flatMap(extensionRegistryField -> {
            DefaultExecutableInvoker invoker = (DefaultExecutableInvoker)extensionContext.getExecutableInvoker();
            long extensionRegistryFieldOffset = UnsafeProvider.getUnsafe().objectFieldOffset((Field)extensionRegistryField);
            return Optional.ofNullable((ExtensionRegistry)UnsafeProvider.getUnsafe().getObject(invoker, extensionRegistryFieldOffset));
        });
    }

    public void beforeFirstExecution() {
    }

    public void beforeEachExecution() throws Throwable {
        this.testClassInstanceUpdater.run();
        for (LifecycleMethodsInvoker.ThrowingRunnable runnable : this.beforeEachRunnables) {
            runnable.run();
        }
    }

    public void afterEachExecution() throws Throwable {
        for (LifecycleMethodsInvoker.ThrowingRunnable runnable : this.afterEachRunnables) {
            runnable.run();
        }
    }

    public void afterLastExecution() {
    }

    public Object getTestClassInstance() {
        return this.testClassInstanceSupplier.get();
    }

    @FunctionalInterface
    static interface ThrowingConsumer {
        public void accept(Object var1) throws Exception;
    }
}

