/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.junit.ApiStats;
import com.code_intelligence.jazzer.utils.Log;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApiStatsInterval
implements ApiStats {
    public static final String NO_STATS = "";
    private static final long timeIntervalForStatsPrint = 5000L;
    private final Map<String, Stat> stats = new HashMap<String, Stat>();
    private long currentTime = System.currentTimeMillis();

    @Override
    public void addStat(String endpointUri, String method, int responseStatusCode) {
        String key = endpointUri + method;
        Stat stat = this.stats.computeIfAbsent(key, k -> new Stat(endpointUri, method));
        stat.addResponseStatusCount(String.valueOf(responseStatusCode));
        if (System.currentTimeMillis() - this.currentTime > 5000L) {
            this.currentTime = System.currentTimeMillis();
            Log.println((String)this.stringify());
        }
    }

    @Override
    public String stringify() {
        if (this.stats.isEmpty()) {
            return NO_STATS;
        }
        StringBuilder sb = new StringBuilder("==API STATS== {\"endpoints\":[");
        List sortedValues = this.stats.values().stream().sorted(Comparator.comparing(s -> s.method).thenComparing(s -> s.endpointUri)).collect(Collectors.toList());
        for (Stat stat : sortedValues) {
            sb.append("{\"method\":\"");
            sb.append(stat.method);
            sb.append("\",\"URL\":\"");
            sb.append(stat.endpointUri);
            sb.append("\",\"statusCodes\":{");
            Map<String, Integer> counts = stat.responseStatusCounts;
            List sortedEntries = counts.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
            for (Map.Entry status : sortedEntries) {
                sb.append("\"");
                sb.append((String)status.getKey());
                sb.append("\":");
                sb.append(status.getValue());
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("}}");
            sb.append(",");
        }
        if (!sortedValues.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }

    static final class Stat {
        final String endpointUri;
        final String method;
        final Map<String, Integer> responseStatusCounts;

        Stat(String endpointUri, String method) {
            this.endpointUri = endpointUri;
            this.method = method;
            this.responseStatusCounts = new HashMap<String, Integer>();
        }

        void addResponseStatusCount(String responseStatus) {
            this.responseStatusCounts.compute(responseStatus, (k, v) -> v == null ? 1 : v + 1);
        }
    }
}

