/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.junit;

import com.code_intelligence.jazzer.junit.FuzzTest;
import com.code_intelligence.jazzer.junit.FuzzTestConfigurationError;
import com.code_intelligence.jazzer.junit.FuzzTestExecutor;
import com.code_intelligence.jazzer.junit.FuzzTestFindingException;
import com.code_intelligence.jazzer.junit.FuzzerDictionary;
import com.code_intelligence.jazzer.junit.Lifecycle;
import com.code_intelligence.jazzer.junit.SeedSerializer;
import com.code_intelligence.jazzer.junit.Utils;
import com.code_intelligence.jazzer.utils.Log;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;

class FuzzTestExtensions
implements ExecutionCondition,
InvocationInterceptor,
TestExecutionExceptionHandler {
    private static final String JAZZER_INTERNAL = "com.code_intelligence.jazzer.runtime.JazzerInternal";
    private static final AtomicReference<Method> fuzzTestMethod = new AtomicReference();
    private static Field lastFindingField;
    private static Field hooksEnabledField;

    FuzzTestExtensions() {
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        FuzzTest fuzzTest = (FuzzTest)AnnotationSupport.findAnnotation((AnnotatedElement)invocationContext.getExecutable(), FuzzTest.class).get();
        Optional<Path> dictionaryPath = FuzzerDictionary.createDictionaryFile(extensionContext.getRequiredTestMethod());
        FuzzTestExecutor.configureAndInstallAgent(extensionContext, fuzzTest.maxDuration(), fuzzTest.maxExecutions(), dictionaryPath);
        if (Utils.isMarkedInvocation(invocationContext)) {
            FuzzTestExtensions.startFuzzing(invocation, invocationContext, extensionContext, fuzzTest.lifecycle());
        } else {
            if (Utils.isFuzzing(extensionContext)) {
                this.recordSeedForFuzzing(invocationContext.getArguments(), extensionContext);
            }
            FuzzTestExtensions.runWithHooks(invocation);
        }
    }

    private static void runWithHooks(InvocationInterceptor.Invocation<Void> invocation) throws Throwable {
        Throwable thrown = null;
        FuzzTestExtensions.getLastFindingField().set(null, null);
        try (AutoCloseable ignored = FuzzTestExtensions.withHooksEnabled();){
            invocation.proceed();
        }
        catch (Throwable t) {
            thrown = t;
        }
        Throwable stored = (Throwable)FuzzTestExtensions.getLastFindingField().get(null);
        if (stored != null) {
            throw new FuzzTestFindingException(stored);
        }
        if (thrown != null) {
            throw new FuzzTestFindingException(thrown);
        }
    }

    private static void startFuzzing(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, Lifecycle lifecycle) throws Throwable {
        invocation.skip();
        Optional<Throwable> throwable = FuzzTestExecutor.fromContext(extensionContext).execute(invocationContext, extensionContext, lifecycle);
        if (throwable.isPresent()) {
            throw throwable.get();
        }
    }

    private void recordSeedForFuzzing(List<Object> arguments, ExtensionContext extensionContext) throws IOException {
        byte[] seed;
        SeedSerializer seedSerializer = FuzzTestExtensions.getOrCreateSeedSerializer(extensionContext);
        try {
            seed = seedSerializer.write(arguments.toArray());
        }
        catch (Exception ignored) {
            String argumentTypes = arguments.stream().filter(Objects::nonNull).map(obj -> obj.getClass().getName()).collect(Collectors.joining(","));
            String argumentValues = arguments.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", "));
            Log.warn((String)String.format("JUnit arguments of type(s) %s with value(s) %s can not be serialized as fuzzing inputs. Skipped.", argumentTypes, argumentValues));
            return;
        }
        try {
            FuzzTestExecutor.fromContext(extensionContext).addSeed(seed);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        if (!Utils.isFuzzing(extensionContext)) {
            return ConditionEvaluationResult.enabled((String)"Regression tests are run instead of fuzzing since JAZZER_FUZZ has not been set to a non-empty value");
        }
        try {
            FuzzTestExtensions.getLastFindingField().set(null, null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        if (fuzzTestMethod.compareAndSet(null, extensionContext.getRequiredTestMethod()) || extensionContext.getRequiredTestMethod().equals(fuzzTestMethod.get())) {
            return ConditionEvaluationResult.enabled((String)("Fuzzing " + extensionContext.getRequiredTestMethod()));
        }
        return ConditionEvaluationResult.disabled((String)"Only one fuzz test can be run at a time, but multiple tests have been annotated with @FuzzTest");
    }

    private static SeedSerializer getOrCreateSeedSerializer(ExtensionContext extensionContext) {
        Method method = extensionContext.getRequiredTestMethod();
        return (SeedSerializer)extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{FuzzTestExtensions.class, method})).getOrComputeIfAbsent(SeedSerializer.class, unused -> SeedSerializer.of(method), SeedSerializer.class);
    }

    private static Field getLastFindingField() throws ClassNotFoundException, NoSuchFieldException {
        if (lastFindingField == null) {
            Class<?> jazzerInternal = Class.forName(JAZZER_INTERNAL);
            lastFindingField = jazzerInternal.getField("lastFinding");
        }
        return lastFindingField;
    }

    private static Field getHooksEnabledField() throws ClassNotFoundException, NoSuchFieldException {
        if (hooksEnabledField == null) {
            Class<?> jazzerInternal = Class.forName(JAZZER_INTERNAL);
            hooksEnabledField = jazzerInternal.getField("hooksEnabled");
        }
        return hooksEnabledField;
    }

    private static AutoCloseable withHooksEnabled() throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        Field hooksEnabledField = FuzzTestExtensions.getHooksEnabledField();
        hooksEnabledField.setBoolean(null, true);
        return () -> hooksEnabledField.setBoolean(null, false);
    }

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        if (throwable instanceof ParameterResolutionException) {
            throw new FuzzTestConfigurationError("@FuzzTest does not support parameters resolved via ParameterResolvers. Instead of injecting objects via test method parameters, inject them via test instance properties. Note that test instances are reused across all invocations during fuzzing.", throwable);
        }
        throw throwable;
    }
}

