/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer;

import com.code_intelligence.jazzer.driver.Driver;
import com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni.RulesJni;
import com.code_intelligence.jazzer.utils.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Jazzer {
    public static void main(String[] args2) throws IOException, InterruptedException {
        Jazzer.start(Arrays.stream(args2).collect(Collectors.toList()));
    }

    private static void main(byte[][] nativeArgs) throws IOException, InterruptedException {
        Jazzer.start(Arrays.stream(nativeArgs).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).collect(Collectors.toList()));
    }

    private static void start(List<String> args2) throws IOException, InterruptedException {
        Log.fixOutErr(System.out, System.err);
        Jazzer.parseJazzerArgsToProperties(args2);
        boolean loadASan = Boolean.parseBoolean(System.getProperty("jazzer.asan", "false"));
        boolean loadUBSan = Boolean.parseBoolean(System.getProperty("jazzer.ubsan", "false"));
        boolean fuzzNative = Boolean.parseBoolean(System.getProperty("jazzer.native", Boolean.toString(loadASan || loadUBSan)));
        if ((loadASan || loadUBSan) && !fuzzNative) {
            Log.error("--asan and --ubsan cannot be used without --native");
            System.exit(1);
        }
        if (!fuzzNative) {
            boolean spawnsSubprocesses = args2.stream().anyMatch(arg -> arg.startsWith("-fork=") || arg.startsWith("-jobs=") || arg.startsWith("-merge="));
            String arg0 = spawnsSubprocesses ? Jazzer.prepareArgv0(new HashMap<String, String>()) : "unused_report_a_bug_if_you_see_this";
            args2 = Stream.concat(Stream.of(arg0), args2.stream()).collect(Collectors.toList());
            System.exit(Driver.start(args2, spawnsSubprocesses));
        }
        if (!Jazzer.isLinux() && !Jazzer.isMacOs()) {
            Log.error("--asan, --ubsan, and --native are only supported on Linux and macOS");
            System.exit(1);
        }
        Set argsToFilter = Stream.of("--asan", "--ubsan", "--native").collect(Collectors.toSet());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<Path> preloadLibs = new ArrayList<Path>();
        preloadLibs.add(RulesJni.extractLibrary("jazzer_preload", Jazzer.class));
        if (loadASan) {
            processBuilder.environment().compute("ASAN_OPTIONS", (name, currentValue) -> Jazzer.appendWithPathListSeparator(name, "detect_leaks=0", "verify_asan_link_order=0"));
            Log.warn("Jazzer is not compatible with LeakSanitizer. Leaks are not reported.");
            preloadLibs.add(Jazzer.findHostClangLibrary(Jazzer.asanLibNames()));
        }
        if (loadUBSan) {
            preloadLibs.add(Jazzer.findHostClangLibrary(Jazzer.ubsanLibNames()));
        }
        processBuilder.environment().remove(Jazzer.preloadVariable());
        HashMap<String, String> additionalEnvironment = new HashMap<String, String>();
        additionalEnvironment.put(Jazzer.preloadVariable(), Jazzer.appendWithPathListSeparator(Jazzer.preloadVariable(), (String[])preloadLibs.stream().map(Path::toString).toArray(String[]::new)));
        List<String> subProcessArgs = Stream.concat(Stream.of(Jazzer.prepareArgv0(additionalEnvironment)), args2.stream().filter(arg -> !argsToFilter.contains(arg.split("=")[0]))).collect(Collectors.toList());
        processBuilder.command(subProcessArgs);
        processBuilder.inheritIO();
        System.exit(processBuilder.start().waitFor());
    }

    private static void parseJazzerArgsToProperties(List<String> args2) {
        args2.stream().filter(arg -> arg.startsWith("--")).map(arg -> arg.substring("--".length())).filter(arg -> !arg.isEmpty()).map(Jazzer::parseSingleArg).forEach(e -> System.setProperty("jazzer." + (String)e.getKey(), (String)e.getValue()));
    }

    private static AbstractMap.SimpleEntry<String, String> parseSingleArg(String arg) {
        String[] nameAndValue = arg.split("=", 2);
        if (nameAndValue.length == 2) {
            return new AbstractMap.SimpleEntry<String, String>(nameAndValue[0], nameAndValue[1]);
        }
        if (nameAndValue[0].startsWith("no")) {
            return new AbstractMap.SimpleEntry<String, String>(nameAndValue[0].substring("no".length()), "false");
        }
        return new AbstractMap.SimpleEntry<String, String>(nameAndValue[0], "true");
    }

    private static String prepareArgv0(Map<String, String> additionalEnvironment) throws IOException {
        FileAttribute[] fileAttributeArray;
        String launcherExtension;
        if (!Jazzer.isPosix() && !additionalEnvironment.isEmpty()) {
            throw new IllegalArgumentException("Setting environment variables in the wrapper is only supported on POSIX systems");
        }
        char shellQuote = Jazzer.isPosix() ? (char)'\'' : '\"';
        String launcherTemplate = Jazzer.isPosix() ? "#!/usr/bin/env sh\n%s $@\n" : "@echo off\r\n%s %%*\r\n";
        String string = launcherExtension = Jazzer.isPosix() ? ".sh" : ".bat";
        if (Jazzer.isPosix()) {
            FileAttribute[] fileAttributeArray2 = new FileAttribute[1];
            fileAttributeArray = fileAttributeArray2;
            fileAttributeArray2[0] = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        } else {
            fileAttributeArray = new FileAttribute[]{};
        }
        FileAttribute[] launcherScriptAttributes = fileAttributeArray;
        String env = additionalEnvironment.entrySet().stream().map(e -> (String)e.getKey() + "='" + (String)e.getValue() + "'").collect(Collectors.joining(" "));
        String command = Stream.concat(Stream.of(Jazzer.javaBinary().toString()), Jazzer.javaBinaryArgs()).map(str -> shellQuote + str + shellQuote).collect(Collectors.joining(" "));
        String invocation = env.isEmpty() ? command : env + " " + command;
        String launcherContent = String.format(launcherTemplate, invocation);
        Path launcher = Files.createTempFile("jazzer-", launcherExtension, launcherScriptAttributes);
        launcher.toFile().deleteOnExit();
        Files.write(launcher, launcherContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return launcher.toAbsolutePath().toString();
    }

    private static Path javaBinary() {
        return Paths.get(System.getProperty("java.home"), "bin", Jazzer.isPosix() ? "java" : "java.exe");
    }

    private static Stream<String> javaBinaryArgs() {
        return Stream.concat(ManagementFactory.getRuntimeMXBean().getInputArguments().stream(), Stream.of("-cp", System.getProperty("java.class.path"), "-Djdk.attach.allowAttachSelf=true", Jazzer.class.getName()));
    }

    private static String appendWithPathListSeparator(String name, String ... options) {
        if (options.length == 0) {
            throw new IllegalArgumentException("options must not be empty");
        }
        String currentValue = Optional.ofNullable(System.getenv(name)).orElse("");
        String additionalOptions = String.join((CharSequence)File.pathSeparator, options);
        if (currentValue.isEmpty()) {
            return additionalOptions;
        }
        return currentValue + File.pathSeparator + additionalOptions;
    }

    private static Path findHostClangLibrary(List<String> candidateNames) {
        Optional<Path> path;
        for (String name : candidateNames) {
            path = Jazzer.tryFindLibraryInJazzerNativeSanitizersDir(name);
            if (!path.isPresent()) continue;
            return path.get();
        }
        for (String name : candidateNames) {
            path = Jazzer.tryFindLibraryUsingClang(name);
            if (!path.isPresent()) continue;
            return path.get();
        }
        Log.error("Failed to find one of: " + String.join((CharSequence)", ", candidateNames));
        System.exit(1);
        throw new IllegalStateException("not reached");
    }

    private static Optional<Path> tryFindLibraryInJazzerNativeSanitizersDir(String name) {
        String nativeSanitizersDir = System.getenv("JAZZER_NATIVE_SANITIZERS_DIR");
        if (nativeSanitizersDir == null) {
            return Optional.empty();
        }
        Path candidatePath = Paths.get(nativeSanitizersDir, name);
        if (Files.exists(candidatePath, new LinkOption[0])) {
            return Optional.of(candidatePath);
        }
        return Optional.empty();
    }

    private static Optional<Path> tryFindLibraryUsingClang(String name) {
        byte[] output;
        List<String> command = Arrays.asList(Jazzer.hostClang(), "--print-file-name", name);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            if (process.waitFor() != 0) {
                Log.error(String.format("'%s' exited with exit code %d", String.join((CharSequence)" ", command), process.exitValue()));
                Jazzer.copy(process.getInputStream(), System.out);
                Jazzer.copy(process.getErrorStream(), System.err);
                System.exit(1);
            }
            output = Jazzer.readAllBytes(process.getInputStream());
        }
        catch (IOException | InterruptedException e) {
            Log.error(String.format("Failed to run '%s'", String.join((CharSequence)" ", command)), e);
            System.exit(1);
            throw new IllegalStateException("not reached");
        }
        Path library = Paths.get(new String(output).trim(), new String[0]);
        if (Files.exists(library, new LinkOption[0])) {
            return Optional.of(library);
        }
        return Optional.empty();
    }

    private static String hostClang() {
        return Optional.ofNullable(System.getenv("CC")).orElse("clang");
    }

    private static List<String> asanLibNames() {
        if (Jazzer.isLinux()) {
            return Arrays.asList("libclang_rt.asan.so", "libclang_rt.asan-x86_64.so");
        }
        return Collections.singletonList("libclang_rt.asan_osx_dynamic.dylib");
    }

    private static List<String> ubsanLibNames() {
        if (Jazzer.isLinux()) {
            return Arrays.asList("libclang_rt.ubsan_standalone.so", "libclang_rt.ubsan_standalone-x86_64.so");
        }
        return Collections.singletonList("libclang_rt.ubsan_osx_dynamic.dylib");
    }

    private static String preloadVariable() {
        return Jazzer.isLinux() ? "LD_PRELOAD" : "DYLD_INSERT_LIBRARIES";
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    private static boolean isMacOs() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    private static boolean isPosix() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Jazzer.copy(in, out);
        return out.toByteArray();
    }

    private static void copy(InputStream source, OutputStream target) throws IOException {
        int read;
        byte[] buffer = new byte[0x680000];
        while ((read = source.read(buffer)) != -1) {
            target.write(buffer, 0, read);
        }
    }
}

