/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.agent;

import com.code_intelligence.jazzer.agent.CoverageIdException;
import com.code_intelligence.jazzer.agent.CoverageIdStrategy;
import com.code_intelligence.jazzer.agent.CoverageIdStrategyKt;
import com.code_intelligence.jazzer.agent.FileSyncCoverageIdStrategy;
import com.code_intelligence.jazzer.third_party.kotlin.Metadata;
import com.code_intelligence.jazzer.third_party.kotlin.Triple;
import com.code_intelligence.jazzer.third_party.kotlin.collections.CollectionsKt;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.functions.Function1;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.internal.Intrinsics;
import com.code_intelligence.jazzer.third_party.kotlin.sequences.SequencesKt;
import com.code_intelligence.jazzer.third_party.kotlin.text.StringsKt;
import com.code_intelligence.jazzer.utils.Log;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J$\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0016H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/code_intelligence/jazzer/agent/FileSyncCoverageIdStrategy;", "Lcom/code_intelligence/jazzer/agent/CoverageIdStrategy;", "idSyncFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "cachedClassName", "", "cachedFirstId", "", "Ljava/lang/Integer;", "cachedIdCount", "idFileLock", "Ljava/nio/channels/FileLock;", "uuid", "Ljava/util/UUID;", "commitIdCount", "", "idCount", "obtainFirstId", "className", "withIdForClass", "block", "Lkotlin/Function1;", "src_main_java_com_code_intelligence_jazzer_agent-agent_lib"})
public final class FileSyncCoverageIdStrategy
implements CoverageIdStrategy {
    @NotNull
    private final Path idSyncFile;
    @NotNull
    private final UUID uuid;
    @Nullable
    private FileLock idFileLock;
    @Nullable
    private Integer cachedFirstId;
    @Nullable
    private String cachedClassName;
    @Nullable
    private Integer cachedIdCount;

    public FileSyncCoverageIdStrategy(@NotNull Path idSyncFile) {
        Intrinsics.checkNotNullParameter(idSyncFile, "idSyncFile");
        this.idSyncFile = idSyncFile;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID()");
        this.uuid = uUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void withIdForClass(@NotNull String className, @NotNull Function1<? super Integer, Integer> block) {
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(block, "block");
        int actualNumEdgeIds = 0;
        try {
            int firstId = this.obtainFirstId(className);
            actualNumEdgeIds = ((Number)block.invoke((Integer)firstId)).intValue();
        }
        finally {
            this.commitIdCount(actualNumEdgeIds);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int obtainFirstId(String className) {
        try {
            int n;
            void $this$filterTo$iv$iv;
            if (!(this.idFileLock == null)) {
                boolean $i$a$-check-FileSyncCoverageIdStrategy$obtainFirstId$22 = false;
                String $i$a$-check-FileSyncCoverageIdStrategy$obtainFirstId$22 = "Already holding a lock on the ID file";
                throw new IllegalStateException($i$a$-check-FileSyncCoverageIdStrategy$obtainFirstId$22.toString());
            }
            OpenOption[] $i$a$-check-FileSyncCoverageIdStrategy$obtainFirstId$22 = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ};
            FileChannel localIdFile = FileChannel.open(this.idSyncFile, $i$a$-check-FileSyncCoverageIdStrategy$obtainFirstId$22);
            FileLock localIdFileLock = localIdFile.lock();
            if (!(localIdFileLock.isValid() && !localIdFileLock.isShared())) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            FileChannel fileChannel = localIdFileLock.channel();
            Intrinsics.checkNotNullExpressionValue(fileChannel, "localIdFileLock.channel()");
            List idInfo2 = SequencesKt.toList(SequencesKt.map(SequencesKt.filterNot(StringsKt.lineSequence(CoverageIdStrategyKt.readFully(fileChannel)), obtainFirstId.idInfo.1.INSTANCE), obtainFirstId.idInfo.2.INSTANCE));
            this.cachedClassName = className;
            Iterable $this$filter$iv = idInfo2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Triple it = (Triple)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getFirst(), className)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List idInfoForClass = (List)destination$iv$iv;
            switch (idInfoForClass.size()) {
                case 0: {
                    this.idFileLock = localIdFileLock;
                    Integer n2 = (Integer)SequencesKt.lastOrNull(SequencesKt.map(CollectionsKt.asSequence(idInfo2), obtainFirstId.nextFreeId.1.INSTANCE));
                    int nextFreeId2 = n2 != null ? n2 : 0;
                    this.cachedFirstId = nextFreeId2;
                    n = nextFreeId2;
                    break;
                }
                case 1: {
                    localIdFile.close();
                    this.cachedIdCount = (Integer)((Triple)CollectionsKt.single(idInfoForClass)).getThird();
                    n = ((Number)((Triple)CollectionsKt.single(idInfoForClass)).getSecond()).intValue();
                    break;
                }
                default: {
                    localIdFile.close();
                    Log.println(CollectionsKt.joinToString$default(idInfo2, "\n", null, null, 0, null, obtainFirstId.2.INSTANCE, 30, null));
                    throw new IllegalStateException("Multiple entries for " + className + " in ID file");
                }
            }
            return n;
        }
        catch (Exception e) {
            throw new CoverageIdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void commitIdCount(int idCount) {
        AutoCloseable autoCloseable;
        FileLock localIdFileLock = this.idFileLock;
        try {
            if (!(this.cachedClassName != null)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (localIdFileLock == null) {
                if (!(this.cachedIdCount != null)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Integer n = this.cachedIdCount;
                if (!(n != null && idCount == n)) {
                    boolean bl = false;
                    String string = this.cachedClassName + " has " + idCount + " edges, but " + this.cachedIdCount + " edges reserved in ID file";
                    throw new IllegalStateException(string.toString());
                }
            } else {
                if (!(this.cachedFirstId != null)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                FileChannel fileChannel = localIdFileLock.channel();
                Intrinsics.checkNotNullExpressionValue(fileChannel, "localIdFileLock.channel()");
                CoverageIdStrategyKt.append(fileChannel, this.cachedClassName + ':' + this.cachedFirstId + ':' + idCount + ':' + this.uuid + '\n');
                localIdFileLock.channel().force(true);
            }
            this.idFileLock = null;
            this.cachedFirstId = null;
            this.cachedIdCount = null;
            this.cachedClassName = null;
            autoCloseable = localIdFileLock;
            if (autoCloseable == null || (autoCloseable = ((FileLock)autoCloseable).channel()) == null) return;
        }
        catch (Exception e) {
            try {
                throw new CoverageIdException(e);
            }
            catch (Throwable throwable) {
                AutoCloseable autoCloseable2 = localIdFileLock;
                if (autoCloseable2 == null || (autoCloseable2 = ((FileLock)autoCloseable2).channel()) == null) throw throwable;
                ((AbstractInterruptibleChannel)autoCloseable2).close();
                throw throwable;
            }
        }
        ((AbstractInterruptibleChannel)autoCloseable).close();
        return;
    }
}

