/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.agent;

import com.code_intelligence.jazzer.agent.CoverageIdException;
import com.code_intelligence.jazzer.agent.CoverageIdStrategy;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.instrumentor.ClassInstrumentor;
import com.code_intelligence.jazzer.instrumentor.CoverageRecorder;
import com.code_intelligence.jazzer.instrumentor.Hook;
import com.code_intelligence.jazzer.instrumentor.InstrumentationType;
import com.code_intelligence.jazzer.third_party.io.github.classgraph.ClassGraph;
import com.code_intelligence.jazzer.third_party.io.github.classgraph.ScanResult;
import com.code_intelligence.jazzer.third_party.kotlin.Metadata;
import com.code_intelligence.jazzer.third_party.kotlin.Pair;
import com.code_intelligence.jazzer.third_party.kotlin.collections.CollectionsKt;
import com.code_intelligence.jazzer.third_party.kotlin.collections.MapsKt;
import com.code_intelligence.jazzer.third_party.kotlin.collections.SetsKt;
import com.code_intelligence.jazzer.third_party.kotlin.io.CloseableKt;
import com.code_intelligence.jazzer.third_party.kotlin.io.FilesKt;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.functions.Function1;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.internal.Intrinsics;
import com.code_intelligence.jazzer.third_party.kotlin.math.MathKt;
import com.code_intelligence.jazzer.third_party.kotlin.text.StringsKt;
import com.code_intelligence.jazzer.third_party.kotlin.time.Duration;
import com.code_intelligence.jazzer.third_party.kotlin.time.TimeSource;
import com.code_intelligence.jazzer.third_party.kotlin.time.TimedValue;
import com.code_intelligence.jazzer.utils.ClassNameGlobber;
import com.code_intelligence.jazzer.utils.Log;
import java.io.Closeable;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0017H\u0002J \u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J<\u0010\u001e\u001a\u0004\u0018\u00010\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0019H\u0016JF\u0010\u001e\u001a\u0004\u0018\u00010\u00192\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0019H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010)\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/code_intelligence/jazzer/agent/RuntimeInstrumentor;", "Ljava/lang/instrument/ClassFileTransformer;", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "classesToFullyInstrument", "Lcom/code_intelligence/jazzer/utils/ClassNameGlobber;", "classesToHookInstrument", "instrumentationTypes", "", "Lcom/code_intelligence/jazzer/instrumentor/InstrumentationType;", "includedHooks", "", "Lcom/code_intelligence/jazzer/instrumentor/Hook;", "customHooks", "additionalClassesToHookInstrument", "coverageIdSynchronizer", "Lcom/code_intelligence/jazzer/agent/CoverageIdStrategy;", "dumpClassesDir", "Ljava/nio/file/Path;", "(Ljava/lang/instrument/Instrumentation;Lcom/code_intelligence/jazzer/utils/ClassNameGlobber;Lcom/code_intelligence/jazzer/utils/ClassNameGlobber;Ljava/util/Set;Ljava/util/List;Ljava/util/List;Lcom/code_intelligence/jazzer/utils/ClassNameGlobber;Lcom/code_intelligence/jazzer/agent/CoverageIdStrategy;Ljava/nio/file/Path;)V", "dumpToClassFile", "", "internalClassName", "", "bytecode", "", "basenameSuffix", "instrument", "fullInstrumentation", "", "transform", "loader", "Ljava/lang/ClassLoader;", "classBeingRedefined", "Ljava/lang/Class;", "protectionDomain", "Ljava/security/ProtectionDomain;", "classfileBuffer", "module", "Ljava/lang/Module;", "transformInternal", "maybeClassfileBuffer", "src_main_java_com_code_intelligence_jazzer_agent-agent_lib"})
public final class RuntimeInstrumentor
implements ClassFileTransformer {
    @NotNull
    private final Instrumentation instrumentation;
    @NotNull
    private final ClassNameGlobber classesToFullyInstrument;
    @NotNull
    private final ClassNameGlobber classesToHookInstrument;
    @NotNull
    private final Set<InstrumentationType> instrumentationTypes;
    @NotNull
    private final List<Hook> includedHooks;
    @NotNull
    private final List<Hook> customHooks;
    @NotNull
    private final ClassNameGlobber additionalClassesToHookInstrument;
    @NotNull
    private final CoverageIdStrategy coverageIdSynchronizer;
    @Nullable
    private final Path dumpClassesDir;

    public RuntimeInstrumentor(@NotNull Instrumentation instrumentation, @NotNull ClassNameGlobber classesToFullyInstrument, @NotNull ClassNameGlobber classesToHookInstrument, @NotNull Set<? extends InstrumentationType> instrumentationTypes, @NotNull List<Hook> includedHooks, @NotNull List<Hook> customHooks, @NotNull ClassNameGlobber additionalClassesToHookInstrument, @NotNull CoverageIdStrategy coverageIdSynchronizer, @Nullable Path dumpClassesDir) {
        Intrinsics.checkNotNullParameter(instrumentation, "instrumentation");
        Intrinsics.checkNotNullParameter(classesToFullyInstrument, "classesToFullyInstrument");
        Intrinsics.checkNotNullParameter(classesToHookInstrument, "classesToHookInstrument");
        Intrinsics.checkNotNullParameter(instrumentationTypes, "instrumentationTypes");
        Intrinsics.checkNotNullParameter(includedHooks, "includedHooks");
        Intrinsics.checkNotNullParameter(customHooks, "customHooks");
        Intrinsics.checkNotNullParameter(additionalClassesToHookInstrument, "additionalClassesToHookInstrument");
        Intrinsics.checkNotNullParameter(coverageIdSynchronizer, "coverageIdSynchronizer");
        this.instrumentation = instrumentation;
        this.classesToFullyInstrument = classesToFullyInstrument;
        this.classesToHookInstrument = classesToHookInstrument;
        this.instrumentationTypes = instrumentationTypes;
        this.includedHooks = includedHooks;
        this.customHooks = customHooks;
        this.additionalClassesToHookInstrument = additionalClassesToHookInstrument;
        this.coverageIdSynchronizer = coverageIdSynchronizer;
        this.dumpClassesDir = dumpClassesDir;
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @NotNull String internalClassName, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @NotNull byte[] classfileBuffer) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
        Intrinsics.checkNotNullParameter(classfileBuffer, "classfileBuffer");
        try {
            if (StringsKt.startsWith$default(internalClassName, "com/code_intelligence/jazzer/", false, 2, null)) {
                return null;
            }
            byte[] byArray2 = byArray = classfileBuffer;
            String string = internalClassName;
            RuntimeInstrumentor runtimeInstrumentor = this;
            boolean bl = false;
            boolean bl2 = loader == null && classBeingRedefined != null;
            byArray = runtimeInstrumentor.transformInternal(string, (byte[])(!bl2 ? byArray : null));
        }
        catch (Throwable t) {
            if (this.dumpClassesDir != null) {
                this.dumpToClassFile(internalClassName, classfileBuffer, ".failed");
            }
            Log.warn("Failed to instrument " + internalClassName + ':', t);
            throw t;
        }
        byte[] instrumentedByteCode = byArray;
        boolean bl = false;
        if (instrumentedByteCode != null && this.dumpClassesDir != null) {
            RuntimeInstrumentor.dumpToClassFile$default(this, internalClassName, instrumentedByteCode, null, 4, null);
            this.dumpToClassFile(internalClassName, classfileBuffer, ".original");
        }
        return byArray;
    }

    private final void dumpToClassFile(String internalClassName, byte[] bytecode, String basenameSuffix) {
        String relativePath = internalClassName + basenameSuffix + ".class";
        Path path = this.dumpClassesDir;
        Intrinsics.checkNotNull(path);
        Path absolutePath = path.resolve(relativePath);
        File dumpFile = absolutePath.toFile();
        dumpFile.getParentFile().mkdirs();
        Intrinsics.checkNotNullExpressionValue(dumpFile, "dumpFile");
        FilesKt.writeBytes(dumpFile, bytecode);
    }

    static /* synthetic */ void dumpToClassFile$default(RuntimeInstrumentor runtimeInstrumentor, String string, byte[] byArray, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        runtimeInstrumentor.dumpToClassFile(string, byArray, string2);
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable Module module, @Nullable ClassLoader loader, @NotNull String internalClassName, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @NotNull byte[] classfileBuffer) {
        Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
        Intrinsics.checkNotNullParameter(classfileBuffer, "classfileBuffer");
        try {
            if (module != null && !module.canRead(RuntimeInstrumentor.class.getModule())) {
                if (!this.instrumentation.isModifiableModule(module)) {
                    String prettyClassName = StringsKt.replace$default(internalClassName, '/', '.', false, 4, null);
                    Log.warn("Failed to instrument " + prettyClassName + " in unmodifiable module " + module.getName() + ", skipping");
                    return null;
                }
                this.instrumentation.redefineModule(module, SetsKt.setOf(RuntimeInstrumentor.class.getModule()), MapsKt.emptyMap(), MapsKt.emptyMap(), SetsKt.emptySet(), MapsKt.emptyMap());
            }
        }
        catch (Throwable t) {
            if (this.dumpClassesDir != null) {
                this.dumpToClassFile(internalClassName, classfileBuffer, ".failed");
            }
            Log.warn("Failed to instrument " + internalClassName + ':', t);
            throw t;
        }
        return this.transform(loader, internalClassName, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] transformInternal(@NotNull String internalClassName, @Nullable byte[] maybeClassfileBuffer) {
        byte[] byArray;
        Object object;
        Pair<Boolean, Boolean> pair;
        Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
        if (this.classesToFullyInstrument.includes(internalClassName)) {
            pair = new Pair<Boolean, Boolean>(true, true);
        } else if (this.classesToHookInstrument.includes(internalClassName)) {
            pair = new Pair<Boolean, Boolean>(false, true);
        } else if (this.additionalClassesToHookInstrument.includes(internalClassName)) {
            pair = new Pair<Boolean, Boolean>(false, false);
        } else {
            return null;
        }
        Pair<Boolean, Boolean> pair2 = pair;
        boolean fullInstrumentation = (Boolean)pair2.component1();
        boolean printInfo = (Boolean)pair2.component2();
        String className = StringsKt.replace$default(internalClassName, '/', '.', false, 4, null);
        Object object2 = maybeClassfileBuffer;
        if (maybeClassfileBuffer == null) {
            object = new String[]{className};
            object = new ClassGraph().enableSystemJarsAndModules().ignoreClassVisibility().acceptClasses((String[])object).scan();
            Throwable throwable = null;
            try {
                Object it = (ScanResult)object;
                boolean bl = false;
                it = ((ScanResult)it).getClassInfo(className).getResource().load();
                object2 = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        byte[] classfileBuffer = object2;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        try {
            Intrinsics.checkNotNullExpressionValue(classfileBuffer, "classfileBuffer");
            byArray = this.instrument(internalClassName, classfileBuffer, fullInstrumentation);
        }
        catch (CoverageIdException e) {
            Log.error("Coverage IDs are out of sync");
            e.printStackTrace();
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        byte[] result$iv$iv = byArray;
        object = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(mark$iv$iv), null);
        byte[] instrumentedBytecode = (byte[])((TimedValue)object).component1();
        long duration = ((TimedValue)object).component2-UwyO8pc();
        long durationInMs = Duration.getInWholeMilliseconds-impl(duration);
        int sizeIncrease = MathKt.roundToInt(100.0 * (double)(instrumentedBytecode.length - classfileBuffer.length) / (double)classfileBuffer.length);
        if (printInfo) {
            if (fullInstrumentation) {
                Log.info("Instrumented " + className + " (took " + durationInMs + " ms, size +" + sizeIncrease + "%)");
            } else {
                Log.info("Instrumented " + className + " with custom hooks only (took " + durationInMs + " ms, size +" + sizeIncrease + "%)");
            }
        }
        return instrumentedBytecode;
    }

    private final byte[] instrument(String internalClassName, byte[] bytecode, boolean fullInstrumentation) {
        String classWithHooksEnabledField = Opt.conditionalHooks ? "com/code_intelligence/jazzer/runtime/JazzerInternal" : null;
        ClassInstrumentor $this$instrument_u24lambda_u244 = new ClassInstrumentor(internalClassName, bytecode);
        boolean bl = false;
        if (fullInstrumentation) {
            $this$instrument_u24lambda_u244.traceDataFlow(this.instrumentationTypes);
            $this$instrument_u24lambda_u244.hooks(CollectionsKt.plus((Collection)this.includedHooks, (Iterable)this.customHooks), classWithHooksEnabledField);
            this.coverageIdSynchronizer.withIdForClass(internalClassName, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>($this$instrument_u24lambda_u244, internalClassName, bytecode){
                final /* synthetic */ ClassInstrumentor $this_run;
                final /* synthetic */ String $internalClassName;
                final /* synthetic */ byte[] $bytecode;
                {
                    this.$this_run = $receiver;
                    this.$internalClassName = $internalClassName;
                    this.$bytecode = $bytecode;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int firstId) {
                    Integer n = this.$this_run.coverage(firstId);
                    String string = this.$internalClassName;
                    byte[] byArray = this.$bytecode;
                    int actualNumEdgeIds = ((Number)n).intValue();
                    boolean bl = false;
                    CoverageRecorder.INSTANCE.recordInstrumentedClass(string, byArray, firstId, actualNumEdgeIds);
                    return n;
                }
            });
        } else {
            $this$instrument_u24lambda_u244.hooks((Iterable<Hook>)this.customHooks, classWithHooksEnabledField);
        }
        return $this$instrument_u24lambda_u244.getInstrumentedBytecode();
    }
}

