/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.autofuzz;

import com.code_intelligence.jazzer.api.AutofuzzConstructionException;
import com.code_intelligence.jazzer.api.AutofuzzInvocationException;
import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.autofuzz.AccessibleObjectLookup;
import com.code_intelligence.jazzer.autofuzz.AutofuzzCodegenVisitor;
import com.code_intelligence.jazzer.autofuzz.Meta;
import com.code_intelligence.jazzer.utils.Log;
import com.code_intelligence.jazzer.utils.SimpleGlobMatcher;
import com.code_intelligence.jazzer.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FuzzTarget {
    private static final String AUTOFUZZ_REPRODUCER_TEMPLATE = "public class Crash_%1$s {\n  public static void main(String[] args) throws Throwable {\n    Crash_%1$s.class.getClassLoader().setDefaultAssertionStatus(true);\n    %2$s;\n  }\n}";
    private static final long MAX_EXECUTIONS_WITHOUT_INVOCATION = 100L;
    private static Meta meta;
    private static String methodReference;
    private static Executable[] targetExecutables;
    private static Map<Executable, Class<?>[]> throwsDeclarations;
    private static Set<SimpleGlobMatcher> ignoredExceptionMatchers;
    private static long executionsSinceLastInvocation;

    public static void fuzzerInitialize(String[] args2) {
        String descriptor2;
        String methodName;
        if (args2.length == 0 || !args2[0].contains("::")) {
            Log.error("Expected the argument to --autofuzz to be a method reference (e.g. System.out::println)");
            System.exit(1);
        }
        methodReference = args2[0];
        String[] parts = methodReference.split("::", 2);
        String className = parts[0];
        String methodNameAndOptionalDescriptor = parts[1];
        int descriptorStart = methodNameAndOptionalDescriptor.indexOf(40);
        if (descriptorStart != -1) {
            methodName = methodNameAndOptionalDescriptor.substring(0, descriptorStart);
            try {
                descriptor2 = URLDecoder.decode(methodNameAndOptionalDescriptor.substring(descriptorStart), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Log.error(e);
                System.exit(1);
                return;
            }
        } else {
            methodName = methodNameAndOptionalDescriptor;
            descriptor2 = null;
        }
        Class<?> targetClassTemp = null;
        String targetClassName = className;
        do {
            try {
                targetClassTemp = Class.forName(targetClassName);
            }
            catch (ClassNotFoundException e) {
                int classSeparatorIndex = targetClassName.lastIndexOf(".");
                if (classSeparatorIndex == -1) {
                    Log.error(String.format("Failed to find class %s for autofuzz, please ensure it is contained in the classpath specified with --cp and specify the full package name", className));
                    System.exit(1);
                    return;
                }
                StringBuilder classNameBuilder = new StringBuilder(targetClassName);
                classNameBuilder.setCharAt(classSeparatorIndex, '$');
                targetClassName = classNameBuilder.toString();
            }
        } while (targetClassTemp == null);
        Class<?> targetClass = targetClassTemp;
        AccessibleObjectLookup lookup = new AccessibleObjectLookup(targetClass);
        meta = new Meta(targetClass);
        boolean isConstructor = methodName.equals("new");
        targetExecutables = isConstructor ? (Executable[])Arrays.stream(lookup.getAccessibleConstructors(targetClass)).filter(constructor -> constructor.getDeclaringClass().equals(targetClass)).filter(constructor -> descriptor2 == null && Modifier.isPublic(constructor.getModifiers()) || Utils.getReadableDescriptor(constructor).equals(descriptor2)).toArray(Executable[]::new) : (Executable[])Arrays.stream(lookup.getAccessibleMethods(targetClass)).filter(method -> method.getDeclaringClass().equals(targetClass)).filter(method -> method.getName().equals(methodName) && (descriptor2 == null && Modifier.isPublic(method.getModifiers()) || Utils.getReadableDescriptor(method).equals(descriptor2))).toArray(Executable[]::new);
        if (targetExecutables.length == 0) {
            if (isConstructor) {
                if (descriptor2 == null) {
                    Log.error(String.format("Failed to find constructors in class %s for autofuzz.%n", className));
                } else {
                    Log.error(String.format("Failed to find constructors with signature %s in class %s for autofuzz.%nPublic constructors declared by the class:%n%s", descriptor2, className, Arrays.stream(lookup.getAccessibleConstructors(targetClass)).filter(constructor -> Modifier.isPublic(constructor.getModifiers())).filter(constructor -> constructor.getDeclaringClass().equals(targetClass)).map(method -> String.format("%s::new%s", method.getDeclaringClass().getName(), Utils.getReadableDescriptor(method))).distinct().collect(Collectors.joining(System.lineSeparator()))));
                }
            } else if (descriptor2 == null) {
                Log.error(String.format("Failed to find methods named %s in class %s for autofuzz.%nPublic methods declared by the class:%n%s", methodName, className, Arrays.stream(lookup.getAccessibleMethods(targetClass)).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> method.getDeclaringClass().equals(targetClass)).map(method -> String.format("%s::%s", method.getDeclaringClass().getName(), method.getName())).distinct().collect(Collectors.joining(System.lineSeparator()))));
            } else {
                Log.error(String.format("Failed to find public methods named %s with signature %s in class %s for autofuzz.%nPublic methods with that name:%n%s", methodName, descriptor2, className, Arrays.stream(lookup.getAccessibleMethods(targetClass)).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> method.getDeclaringClass().equals(targetClass)).filter(method -> method.getName().equals(methodName)).map(method -> String.format("%s::%s%s", method.getDeclaringClass().getName(), method.getName(), Utils.getReadableDescriptor(method))).distinct().collect(Collectors.joining(System.lineSeparator()))));
            }
            System.exit(1);
        }
        for (Executable executable : targetExecutables) {
            executable.setAccessible(true);
        }
        ignoredExceptionMatchers = Arrays.stream(args2).skip(1L).filter(s -> s.contains("*")).map(SimpleGlobMatcher::new).collect(Collectors.toSet());
        List alwaysIgnore = Arrays.stream(args2).skip(1L).filter(s -> !s.contains("*")).map(name -> {
            try {
                return ClassLoader.getSystemClassLoader().loadClass((String)name);
            }
            catch (ClassNotFoundException e) {
                Log.error(String.format("Failed to find class '%s' specified in --autofuzz_ignore", name));
                System.exit(1);
                throw new Error("Not reached");
            }
        }).collect(Collectors.toList());
        throwsDeclarations = Arrays.stream(targetExecutables).collect(Collectors.toMap(method -> method, method -> (Class[])Stream.concat(Arrays.stream(method.getExceptionTypes()), alwaysIgnore.stream()).toArray(Class[]::new)));
    }

    public static void fuzzerTestOneInput(FuzzedDataProvider data2) throws Throwable {
        AutofuzzCodegenVisitor codegenVisitor = null;
        if (Meta.IS_DEBUG) {
            codegenVisitor = new AutofuzzCodegenVisitor();
        }
        FuzzTarget.fuzzerTestOneInput(data2, codegenVisitor);
        if (codegenVisitor != null) {
            Log.println(codegenVisitor.generate());
        }
    }

    public static void dumpReproducer(FuzzedDataProvider data2, String reproducerPath, String sha) {
        AutofuzzCodegenVisitor codegenVisitor = new AutofuzzCodegenVisitor();
        try {
            FuzzTarget.fuzzerTestOneInput(data2, codegenVisitor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String javaSource = String.format(AUTOFUZZ_REPRODUCER_TEMPLATE, sha, codegenVisitor.generate());
        Path javaPath = Paths.get(reproducerPath, String.format("Crash_%s.java", sha));
        try {
            Files.write(javaPath, javaSource.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Log.error(String.format("Failed to write Java reproducer to %s%n", javaPath), e);
        }
        Log.println(String.format("reproducer_path='%s'; Java reproducer written to %s%n", reproducerPath, javaPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fuzzerTestOneInput(FuzzedDataProvider data2, AutofuzzCodegenVisitor codegenVisitor) throws Throwable {
        Executable targetExecutable = targetExecutables.length == 1 ? targetExecutables[0] : (Executable)data2.pickValue((Object[])targetExecutables);
        Object returnValue = null;
        try {
            returnValue = targetExecutable instanceof Method ? meta.autofuzz(data2, (Method)targetExecutable, codegenVisitor) : meta.autofuzz(data2, (Constructor)targetExecutable, codegenVisitor);
            executionsSinceLastInvocation = 0L;
        }
        catch (AutofuzzConstructionException e) {
            if (Meta.IS_DEBUG) {
                Log.error(e);
            }
            if (++executionsSinceLastInvocation >= 100L) {
                Log.error(String.format("Failed to generate valid arguments to '%s' in %d attempts; giving up", methodReference, executionsSinceLastInvocation));
                System.exit(1);
            } else if (executionsSinceLastInvocation == 50L) {
                Meta.rescanClasspath();
            }
        }
        catch (AutofuzzInvocationException e) {
            executionsSinceLastInvocation = 0L;
            Throwable cause = e.getCause();
            Class<?> causeClass = cause.getClass();
            for (Class<?> declaredThrow : throwsDeclarations.get(targetExecutable)) {
                if (!declaredThrow.isAssignableFrom(causeClass)) continue;
                return;
            }
        }
        catch (Throwable t) {
            Log.error("Unexpected exception encountered during autofuzz", t);
            System.exit(1);
        }
        finally {
            if (returnValue instanceof Closeable) {
                ((Closeable)returnValue).close();
            }
        }
    }

    private static void cleanStackTraces(Throwable t) {
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            String className;
            int firstInterestingPos;
            StackTraceElement[] elements = cause.getStackTrace();
            for (firstInterestingPos = elements.length - 1; firstInterestingPos > 0 && ((className = elements[firstInterestingPos].getClassName()).startsWith("com.code_intelligence.jazzer.autofuzz.") || className.startsWith("java.lang.reflect.") || className.startsWith("jdk.internal.reflect.")); --firstInterestingPos) {
            }
            cause.setStackTrace(Arrays.copyOfRange(elements, 0, firstInterestingPos + 1));
        }
    }

    private static /* synthetic */ boolean lambda$fuzzerTestOneInput$22(Class causeClass, SimpleGlobMatcher m) {
        return m.matches(causeClass.getName());
    }

    static {
        executionsSinceLastInvocation = 0L;
    }
}

