/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.autofuzz;

import com.code_intelligence.jazzer.api.AutofuzzConstructionException;
import com.code_intelligence.jazzer.api.AutofuzzInvocationException;
import com.code_intelligence.jazzer.api.Consumer1;
import com.code_intelligence.jazzer.api.Consumer2;
import com.code_intelligence.jazzer.api.Consumer3;
import com.code_intelligence.jazzer.api.Consumer4;
import com.code_intelligence.jazzer.api.Consumer5;
import com.code_intelligence.jazzer.api.Function1;
import com.code_intelligence.jazzer.api.Function2;
import com.code_intelligence.jazzer.api.Function3;
import com.code_intelligence.jazzer.api.Function4;
import com.code_intelligence.jazzer.api.Function5;
import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.autofuzz.AccessibleObjectLookup;
import com.code_intelligence.jazzer.autofuzz.AutofuzzCodegenVisitor;
import com.code_intelligence.jazzer.autofuzz.AutofuzzError;
import com.code_intelligence.jazzer.autofuzz.YourAverageJavaClass;
import com.code_intelligence.jazzer.third_party.io.github.classgraph.ClassGraph;
import com.code_intelligence.jazzer.third_party.io.github.classgraph.ClassInfoList;
import com.code_intelligence.jazzer.third_party.io.github.classgraph.ScanResult;
import com.code_intelligence.jazzer.third_party.net.jodah.typetools.TypeResolver;
import com.code_intelligence.jazzer.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Meta {
    public static final boolean IS_DEBUG = Meta.isDebug();
    private static final Meta PUBLIC_LOOKUP_INSTANCE = new Meta(null);
    private static final boolean IS_TEST = Meta.isTest();
    private static final WeakHashMap<Class<?>, List<Class<?>>> implementingClassesCache = new WeakHashMap();
    private static final WeakHashMap<Class<?>, List<Class<?>>> nestedBuilderClassesCache = new WeakHashMap();
    private static final WeakHashMap<Class<?>, List<Method>> originalObjectCreationMethodsCache = new WeakHashMap();
    private static final WeakHashMap<Class<?>, List<Method>> cascadingBuilderMethodsCache = new WeakHashMap();
    private final AccessibleObjectLookup lookup;

    public Meta(Class<?> referenceClass) {
        this.lookup = new AccessibleObjectLookup(referenceClass);
    }

    public static <T1> void autofuzz(FuzzedDataProvider data2, Consumer1<T1> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer1.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0));
    }

    public static <T1, T2> void autofuzz(FuzzedDataProvider data2, Consumer2<T1, T2> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer2.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 1));
    }

    public static <T1, T2, T3> void autofuzz(FuzzedDataProvider data2, Consumer3<T1, T2, T3> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer3.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 2));
    }

    public static <T1, T2, T3, T4> void autofuzz(FuzzedDataProvider data2, Consumer4<T1, T2, T3, T4> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer4.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 2), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 3));
    }

    public static <T1, T2, T3, T4, T5> void autofuzz(FuzzedDataProvider data2, Consumer5<T1, T2, T3, T4, T5> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Consumer5.class, func.getClass());
        func.accept(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 2), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 3), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 4));
    }

    public static <T1, R> R autofuzz(FuzzedDataProvider data2, Function1<T1, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function1.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0));
    }

    public static <T1, T2, R> R autofuzz(FuzzedDataProvider data2, Function2<T1, T2, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function2.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 1));
    }

    public static <T1, T2, T3, R> R autofuzz(FuzzedDataProvider data2, Function3<T1, T2, T3, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function3.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 2));
    }

    public static <T1, T2, T3, T4, R> R autofuzz(FuzzedDataProvider data2, Function4<T1, T2, T3, T4, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function4.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 2), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 3));
    }

    public static <T1, T2, T3, T4, T5, R> R autofuzz(FuzzedDataProvider data2, Function5<T1, T2, T3, T4, T5, R> func) {
        Class<?>[] types = TypeResolver.resolveRawArguments(Function5.class, func.getClass());
        return (R)func.apply(PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 0), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 1), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 2), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 3), PUBLIC_LOOKUP_INSTANCE.consumeChecked(data2, types, 4));
    }

    public static Object consume(FuzzedDataProvider data2, Class<?> type2) {
        return PUBLIC_LOOKUP_INSTANCE.consume(data2, type2, null);
    }

    static void rescanClasspath() {
        implementingClassesCache.clear();
    }

    private static boolean isTest() {
        String value = System.getenv("JAZZER_AUTOFUZZ_TESTING");
        return value != null && !value.isEmpty();
    }

    private static boolean isDebug() {
        String value = System.getenv("JAZZER_AUTOFUZZ_DEBUG");
        return value != null && !value.isEmpty();
    }

    private static int consumeArrayLength(FuzzedDataProvider data2, int sizeOfElement) {
        int bytesToSpend = data2.remainingBytes() / 2;
        return bytesToSpend / Math.max(sizeOfElement, 1);
    }

    private static String deepToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass().isArray()) {
            return String.format("(%s[]) %s", obj.getClass().getComponentType().getName(), Arrays.deepToString((Object[])obj));
        }
        return obj.toString();
    }

    private static String getDebugSummary(Executable executable, Object thisObject, Object[] arguments2) {
        return String.format("%nMethod: %s::%s%s%nthis: %s%nArguments: %s", executable.getDeclaringClass().getName(), executable.getName(), Utils.getReadableDescriptor(executable), thisObject, Arrays.stream(arguments2).map(Meta::deepToString).collect(Collectors.joining(", ")));
    }

    static Class<?> getRawType(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return Meta.getRawType(((ParameterizedType)genericType).getRawType());
        }
        if (genericType instanceof WildcardType) {
            return Object.class;
        }
        if (genericType instanceof TypeVariable) {
            throw new AutofuzzError("Did not expect genericType to be a TypeVariable: " + genericType);
        }
        if (genericType instanceof GenericArrayType) {
            return Array.newInstance(Meta.getRawType(((GenericArrayType)genericType).getGenericComponentType()), 0).getClass();
        }
        throw new AutofuzzError("Got unexpected class implementing Type: " + genericType);
    }

    public Object autofuzz(FuzzedDataProvider data2, Method method) {
        return this.autofuzz(data2, method, null);
    }

    public Object consumeNonStatic(FuzzedDataProvider data2, Class<?> type2) {
        return this.consume(data2, type2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object autofuzz(FuzzedDataProvider data2, Method method, AutofuzzCodegenVisitor visitor2) {
        Object result2;
        if (Modifier.isStatic(method.getModifiers())) {
            if (visitor2 != null) {
                visitor2.pushGroup(String.format("%s.", method.getDeclaringClass().getCanonicalName()), "", "");
            }
            try {
                result2 = this.autofuzz(data2, method, null, visitor2);
            }
            finally {
                if (visitor2 != null) {
                    visitor2.popGroup();
                }
            }
        }
        if (visitor2 != null) {
            visitor2.pushGroup("(", ").", "");
        }
        try {
            Object thisObject = this.consume(data2, method.getDeclaringClass(), visitor2);
            if (thisObject == null) {
                throw new AutofuzzConstructionException();
            }
            result2 = this.autofuzz(data2, method, thisObject, visitor2);
        }
        finally {
            if (visitor2 != null) {
                visitor2.popGroup();
            }
        }
        return result2;
    }

    public Object autofuzz(FuzzedDataProvider data2, Method method, Object thisObject) {
        return this.autofuzz(data2, method, thisObject, null);
    }

    Object autofuzz(FuzzedDataProvider data2, Method method, Object thisObject, AutofuzzCodegenVisitor visitor2) {
        if (visitor2 != null) {
            visitor2.pushGroup(String.format("%s(", method.getName()), ", ", ")");
        }
        Object[] arguments2 = this.consumeArguments(data2, method, visitor2);
        if (visitor2 != null) {
            visitor2.popGroup();
        }
        try {
            return method.invoke(thisObject, arguments2);
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
            throw new AutofuzzError(Meta.getDebugSummary(method, thisObject, arguments2), e);
        }
        catch (InvocationTargetException e) {
            throw new AutofuzzInvocationException(e.getCause());
        }
    }

    Object autofuzzForConsume(FuzzedDataProvider data2, Constructor<?> constructor, AutofuzzCodegenVisitor visitor2) {
        try {
            return this.autofuzz(data2, constructor, visitor2);
        }
        catch (AutofuzzConstructionException e) {
            throw e;
        }
        catch (AutofuzzInvocationException e) {
            throw new AutofuzzConstructionException(e.getCause());
        }
        catch (Throwable t) {
            throw new AutofuzzConstructionException(t);
        }
    }

    Object autofuzzForConsume(FuzzedDataProvider data2, Method method, Object thisObject, AutofuzzCodegenVisitor visitor2) {
        try {
            return this.autofuzz(data2, method, thisObject, visitor2);
        }
        catch (AutofuzzConstructionException e) {
            throw e;
        }
        catch (AutofuzzInvocationException e) {
            throw new AutofuzzConstructionException(e.getCause());
        }
        catch (Throwable t) {
            throw new AutofuzzConstructionException(t);
        }
    }

    public <R> R autofuzz(FuzzedDataProvider data2, Constructor<R> constructor) {
        return this.autofuzz(data2, constructor, null);
    }

    <R> R autofuzz(FuzzedDataProvider data2, Constructor<R> constructor, AutofuzzCodegenVisitor visitor2) {
        if (visitor2 != null) {
            visitor2.pushGroup(String.format("new %s(", constructor.getDeclaringClass().getCanonicalName()), ", ", ")");
        }
        Object[] arguments2 = this.consumeArguments(data2, constructor, visitor2);
        if (visitor2 != null) {
            visitor2.popGroup();
        }
        try {
            return constructor.newInstance(arguments2);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new AutofuzzError(Meta.getDebugSummary(constructor, null, arguments2), e);
        }
        catch (InvocationTargetException e) {
            throw new AutofuzzInvocationException(e.getCause());
        }
    }

    Object consume(FuzzedDataProvider data2, Type genericType, AutofuzzCodegenVisitor visitor2) {
        Class<?> type2 = Meta.getRawType(genericType);
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            byte result2 = data2.consumeByte();
            if (visitor2 != null) {
                visitor2.pushElement(String.format("(byte) %s", result2));
            }
            return result2;
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            short result3 = data2.consumeShort();
            if (visitor2 != null) {
                visitor2.pushElement(String.format("(short) %s", result3));
            }
            return result3;
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            int result4 = data2.consumeInt();
            if (visitor2 != null) {
                visitor2.pushElement(Integer.toString(result4));
            }
            return result4;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            long result5 = data2.consumeLong();
            if (visitor2 != null) {
                visitor2.pushElement(String.format("%sL", result5));
            }
            return result5;
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            float result6 = data2.consumeFloat();
            if (visitor2 != null) {
                visitor2.pushElement(String.format("%sF", Float.valueOf(result6)));
            }
            return Float.valueOf(result6);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            double result7 = data2.consumeDouble();
            if (visitor2 != null) {
                visitor2.pushElement(Double.toString(result7));
            }
            return result7;
        }
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            boolean result8 = data2.consumeBoolean();
            if (visitor2 != null) {
                visitor2.pushElement(Boolean.toString(result8));
            }
            return result8;
        }
        if (type2 == Character.TYPE || type2 == Character.class) {
            char result9 = data2.consumeChar();
            if (visitor2 != null) {
                visitor2.addCharLiteral(result9);
            }
            return Character.valueOf(result9);
        }
        if (!type2.isPrimitive() && data2.consumeByte() == 0) {
            if (visitor2 != null) {
                if (type2 == Object.class) {
                    visitor2.pushElement("null");
                } else {
                    visitor2.pushElement(String.format("(%s) null", type2.getCanonicalName()));
                }
            }
            return null;
        }
        if (type2 == String.class || type2 == CharSequence.class) {
            String result10 = data2.consumeString(Meta.consumeArrayLength(data2, 1));
            if (visitor2 != null) {
                visitor2.addStringLiteral(result10);
            }
            return result10;
        }
        if (type2.isArray()) {
            if (type2 == byte[].class) {
                byte[] result11 = data2.consumeBytes(Meta.consumeArrayLength(data2, 1));
                if (visitor2 != null) {
                    visitor2.pushElement(IntStream.range(0, result11.length).mapToObj(i -> "(byte) " + result11[i]).collect(Collectors.joining(", ", "new byte[]{", "}")));
                }
                return result11;
            }
            if (type2 == int[].class) {
                int[] result12 = data2.consumeInts(Meta.consumeArrayLength(data2, 4));
                if (visitor2 != null) {
                    visitor2.pushElement(Arrays.stream(result12).mapToObj(String::valueOf).collect(Collectors.joining(", ", "new int[]{", "}")));
                }
                return result12;
            }
            if (type2 == short[].class) {
                short[] result13 = data2.consumeShorts(Meta.consumeArrayLength(data2, 2));
                if (visitor2 != null) {
                    visitor2.pushElement(IntStream.range(0, result13.length).mapToObj(i -> "(short) " + result13[i]).collect(Collectors.joining(", ", "new short[]{", "}")));
                }
                return result13;
            }
            if (type2 == long[].class) {
                long[] result14 = data2.consumeLongs(Meta.consumeArrayLength(data2, 8));
                if (visitor2 != null) {
                    visitor2.pushElement(Arrays.stream(result14).mapToObj(e -> e + "L").collect(Collectors.joining(", ", "new long[]{", "}")));
                }
                return result14;
            }
            if (type2 == boolean[].class) {
                boolean[] result15 = data2.consumeBooleans(Meta.consumeArrayLength(data2, 1));
                if (visitor2 != null) {
                    visitor2.pushElement(Arrays.toString(result15).replace(']', '}').replace("[", "new boolean[]{"));
                }
                return result15;
            }
            if (visitor2 != null) {
                visitor2.pushGroup(String.format("new %s[]{", type2.getComponentType().getName()), ", ", "}");
            }
            int remainingBytesBeforeFirstElementCreation = data2.remainingBytes();
            Object firstElement = this.consume(data2, type2.getComponentType(), visitor2);
            int remainingBytesAfterFirstElementCreation = data2.remainingBytes();
            int sizeOfElementEstimate = remainingBytesBeforeFirstElementCreation - remainingBytesAfterFirstElementCreation;
            Object array = Array.newInstance(type2.getComponentType(), Meta.consumeArrayLength(data2, sizeOfElementEstimate));
            for (int i2 = 0; i2 < Array.getLength(array); ++i2) {
                if (i2 == 0) {
                    Array.set(array, i2, firstElement);
                    continue;
                }
                Array.set(array, i2, this.consume(data2, type2.getComponentType(), visitor2));
            }
            if (visitor2 != null) {
                if (Array.getLength(array) == 0) {
                    visitor2.popElement();
                }
                visitor2.popGroup();
            }
            return array;
        }
        if (type2 == ByteArrayInputStream.class || type2 == InputStream.class) {
            byte[] array = data2.consumeBytes(Meta.consumeArrayLength(data2, 1));
            if (visitor2 != null) {
                visitor2.pushElement(IntStream.range(0, array.length).mapToObj(i -> "(byte) " + array[i]).collect(Collectors.joining(", ", "new java.io.ByteArrayInputStream(new byte[]{", "})")));
            }
            return new ByteArrayInputStream(array);
        }
        if (type2 == Map.class) {
            ParameterizedType mapType = (ParameterizedType)genericType;
            if (mapType.getActualTypeArguments().length != 2) {
                throw new AutofuzzError("Expected Map generic type to have two type parameters: " + mapType);
            }
            Type keyType = mapType.getActualTypeArguments()[0];
            Type valueType = mapType.getActualTypeArguments()[1];
            if (visitor2 != null) {
                visitor2.pushGroup(String.format("java.util.stream.Stream.<java.util.AbstractMap.SimpleEntry<%s, %s>>of(", keyType.getTypeName(), valueType.getTypeName()), ", ", ").collect(java.util.HashMap::new, (map, e) -> map.put(e.getKey(), e.getValue()), java.util.HashMap::putAll)");
            }
            int remainingBytesBeforeFirstEntryCreation = data2.remainingBytes();
            if (visitor2 != null) {
                visitor2.pushGroup("new java.util.AbstractMap.SimpleEntry<>(", ", ", ")");
            }
            Object firstKey = this.consume(data2, keyType, visitor2);
            Object firstValue = this.consume(data2, valueType, visitor2);
            if (visitor2 != null) {
                visitor2.popGroup();
            }
            int remainingBytesAfterFirstEntryCreation = data2.remainingBytes();
            int sizeOfElementEstimate = remainingBytesBeforeFirstEntryCreation - remainingBytesAfterFirstEntryCreation;
            int mapSize = Meta.consumeArrayLength(data2, sizeOfElementEstimate);
            HashMap<Object, Object> map = new HashMap<Object, Object>(mapSize);
            for (int i3 = 0; i3 < mapSize; ++i3) {
                if (i3 == 0) {
                    map.put(firstKey, firstValue);
                    continue;
                }
                if (visitor2 != null) {
                    visitor2.pushGroup("new java.util.AbstractMap.SimpleEntry<>(", ", ", ")");
                }
                map.put(this.consume(data2, keyType, visitor2), this.consume(data2, valueType, visitor2));
                if (visitor2 == null) continue;
                visitor2.popGroup();
            }
            if (visitor2 != null) {
                if (mapSize == 0) {
                    visitor2.popElement();
                }
                visitor2.popGroup();
            }
            return map;
        }
        if (type2.isEnum()) {
            Enum enumValue = (Enum)data2.pickValue((Object[])type2.getEnumConstants());
            if (visitor2 != null) {
                visitor2.pushElement(String.format("%s.%s", type2.getName(), enumValue.name()));
            }
            return enumValue;
        }
        if (type2 == Class.class) {
            if (visitor2 != null) {
                visitor2.pushElement(String.format("%s.class", YourAverageJavaClass.class.getName()));
            }
            return YourAverageJavaClass.class;
        }
        if (type2 == Method.class) {
            if (visitor2 != null) {
                throw new AutofuzzError("codegen has not been implemented for Method.class");
            }
            return data2.pickValue((Object[])this.lookup.getAccessibleMethods(YourAverageJavaClass.class));
        }
        if (type2 == Constructor.class) {
            if (visitor2 != null) {
                throw new AutofuzzError("codegen has not been implemented for Constructor.class");
            }
            return data2.pickValue((Object[])this.lookup.getAccessibleConstructors(YourAverageJavaClass.class));
        }
        if (type2.isInterface() || Modifier.isAbstract(type2.getModifiers())) {
            List<Class<?>> implementingClasses = implementingClassesCache.get(type2);
            if (implementingClasses == null) {
                ClassGraph classGraph = new ClassGraph().enableClassInfo().ignoreClassVisibility().ignoreMethodVisibility().enableInterClassDependencies().rejectPackages("jaz");
                if (!IS_TEST) {
                    classGraph.rejectPackages("com.code_intelligence.jazzer");
                }
                try (ScanResult result16 = classGraph.scan();){
                    ClassInfoList children = type2.isInterface() ? result16.getClassesImplementing(type2) : result16.getSubclasses(type2);
                    implementingClasses = children.getStandardClasses().filter(info -> !Modifier.isAbstract(info.getModifiers())).filter(info -> this.lookup.isAccessible(info, info.getModifiers())).loadClasses();
                    implementingClassesCache.put(type2, implementingClasses);
                }
            }
            if (implementingClasses.isEmpty()) {
                if (IS_DEBUG) {
                    throw new AutofuzzConstructionException(String.format("Could not find classes implementing %s on the classpath", type2.getName()));
                }
                throw new AutofuzzConstructionException();
            }
            if (visitor2 != null && Modifier.isPublic(type2.getModifiers())) {
                visitor2.pushGroup(String.format("(%s) ", type2.getCanonicalName()), "", "");
            }
            Object result17 = this.consume(data2, (Type)data2.pickValue(implementingClasses), visitor2);
            if (visitor2 != null && Modifier.isPublic(type2.getModifiers())) {
                visitor2.popGroup();
            }
            return result17;
        }
        Object[] constructors2 = this.lookup.getAccessibleConstructors(type2);
        if (constructors2.length > 0) {
            boolean applySetters;
            Constructor constructor = (Constructor)data2.pickValue(constructors2);
            boolean bl = applySetters = constructor.getParameterCount() == 0;
            if (visitor2 != null && applySetters) {
                String uniqueVariableName = visitor2.uniqueVariableName();
                visitor2.pushGroup(String.format("((java.util.function.Supplier<%1$s>) (() -> {%1$s %2$s = ", type2.getCanonicalName(), uniqueVariableName), String.format("; %s.", uniqueVariableName), String.format("; return %s;})).get()", uniqueVariableName));
            }
            Object obj = this.autofuzzForConsume(data2, constructor, visitor2);
            if (applySetters) {
                List<Method> potentialSetters = this.getPotentialSetters(type2);
                if (!potentialSetters.isEmpty()) {
                    List pickedSetters = data2.pickValues(potentialSetters, data2.consumeInt(0, potentialSetters.size()));
                    for (Method setter : pickedSetters) {
                        this.autofuzzForConsume(data2, setter, obj, visitor2);
                    }
                }
                if (visitor2 != null) {
                    visitor2.popGroup();
                }
            }
            return obj;
        }
        List<Class<?>> nestedBuilderClasses = this.getNestedBuilderClasses(type2);
        if (!nestedBuilderClasses.isEmpty()) {
            Class pickedBuilder = (Class)data2.pickValue(nestedBuilderClasses);
            List<Method> cascadingBuilderMethods = this.getCascadingBuilderMethods(pickedBuilder);
            List<Method> originalObjectCreationMethods = this.getOriginalObjectCreationMethods(pickedBuilder);
            int pickedMethodsNumber = data2.consumeInt(0, cascadingBuilderMethods.size());
            List pickedMethods = data2.pickValues(cascadingBuilderMethods, pickedMethodsNumber);
            Method builderMethod = (Method)data2.pickValue(originalObjectCreationMethods);
            if (visitor2 != null) {
                visitor2.pushGroup("", ".", "");
            }
            Object builderObj = this.autofuzzForConsume(data2, (Constructor)data2.pickValue((Object[])this.lookup.getAccessibleConstructors(pickedBuilder)), visitor2);
            for (Method method : pickedMethods) {
                builderObj = this.autofuzzForConsume(data2, method, builderObj, visitor2);
            }
            try {
                Object obj = this.autofuzzForConsume(data2, builderMethod, builderObj, visitor2);
                if (visitor2 != null) {
                    visitor2.popGroup();
                }
                return obj;
            }
            catch (Exception e2) {
                throw new AutofuzzConstructionException((Throwable)e2);
            }
        }
        if (IS_DEBUG) {
            String summary = String.format("Failed to generate instance of %s:%nAccessible constructors: %s%nNested subclasses: %s%n", type2.getName(), Arrays.stream(this.lookup.getAccessibleConstructors(type2)).map(Utils::getReadableDescriptor).collect(Collectors.joining(", ")), Arrays.stream(this.lookup.getAccessibleClasses(type2)).map(Class::getName).collect(Collectors.joining(", ")));
            throw new AutofuzzConstructionException(summary);
        }
        throw new AutofuzzConstructionException();
    }

    private List<Class<?>> getNestedBuilderClasses(Class<?> type2) {
        List<Class<Object>> nestedBuilderClasses = nestedBuilderClassesCache.get(type2);
        if (nestedBuilderClasses == null) {
            nestedBuilderClasses = Arrays.stream(this.lookup.getAccessibleClasses(type2)).filter(cls -> cls.getName().endsWith("Builder")).filter(cls -> !this.getOriginalObjectCreationMethods((Class<?>)cls).isEmpty()).collect(Collectors.toList());
            nestedBuilderClassesCache.put(type2, nestedBuilderClasses);
        }
        return nestedBuilderClasses;
    }

    private List<Method> getOriginalObjectCreationMethods(Class<?> builder) {
        List<Method> originalObjectCreationMethods = originalObjectCreationMethodsCache.get(builder);
        if (originalObjectCreationMethods == null) {
            originalObjectCreationMethods = Arrays.stream(this.lookup.getAccessibleMethods(builder)).filter(m -> m.getReturnType() == builder.getEnclosingClass()).collect(Collectors.toList());
            originalObjectCreationMethodsCache.put(builder, originalObjectCreationMethods);
        }
        return originalObjectCreationMethods;
    }

    private List<Method> getCascadingBuilderMethods(Class<?> builder) {
        List<Method> cascadingBuilderMethods = cascadingBuilderMethodsCache.get(builder);
        if (cascadingBuilderMethods == null) {
            cascadingBuilderMethods = Arrays.stream(this.lookup.getAccessibleMethods(builder)).filter(m -> m.getReturnType() == builder).collect(Collectors.toList());
            cascadingBuilderMethodsCache.put(builder, cascadingBuilderMethods);
        }
        return cascadingBuilderMethods;
    }

    private List<Method> getPotentialSetters(Class<?> type2) {
        return Arrays.stream(this.lookup.getAccessibleMethods(type2)).filter(method -> Void.TYPE.equals(method.getReturnType())).filter(method -> method.getParameterCount() == 1).filter(method -> method.getName().startsWith("set")).collect(Collectors.toList());
    }

    public Object[] consumeArguments(FuzzedDataProvider data2, Executable executable, AutofuzzCodegenVisitor visitor2) {
        try {
            Object[] result2 = Arrays.stream(executable.getGenericParameterTypes()).map(type2 -> this.consume(data2, (Type)type2, visitor2)).toArray();
            return result2;
        }
        catch (AutofuzzConstructionException e) {
            throw e;
        }
        catch (AutofuzzInvocationException e) {
            throw new AutofuzzConstructionException(e.getCause());
        }
        catch (Throwable t) {
            throw new AutofuzzConstructionException(t);
        }
    }

    private Object consumeChecked(FuzzedDataProvider data2, Class<?>[] types, int i) {
        Object result2;
        if (types[i] == TypeResolver.Unknown.class) {
            throw new AutofuzzError("Failed to determine type of argument " + (i + 1));
        }
        try {
            result2 = this.consumeNonStatic(data2, types[i]);
        }
        catch (AutofuzzConstructionException e) {
            throw e;
        }
        catch (AutofuzzInvocationException e) {
            throw new AutofuzzConstructionException(e.getCause());
        }
        catch (Throwable t) {
            throw new AutofuzzConstructionException(t);
        }
        if (result2 != null && !types[i].isAssignableFrom(result2.getClass())) {
            throw new AutofuzzError("consume returned " + result2.getClass() + ", but need " + types[i]);
        }
        return result2;
    }
}

