/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.agent.AgentInstaller;
import com.code_intelligence.jazzer.driver.FuzzTargetFinder;
import com.code_intelligence.jazzer.driver.FuzzTargetHolder;
import com.code_intelligence.jazzer.driver.FuzzTargetRunner;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.driver.junit.JUnitRunner;
import com.code_intelligence.jazzer.utils.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;

public class Driver {
    public static int start(List<String> args2, boolean spawnsSubprocesses) throws IOException {
        Optional<JUnitRunner> runner;
        String seed;
        if (spawnsSubprocesses) {
            Path idSyncFile;
            String idSyncFileArg;
            if (!System.getProperty("jazzer.coverage_report", "").isEmpty()) {
                Log.warn("--coverage_report does not support parallel fuzzing and has been disabled");
                System.clearProperty("jazzer.coverage_report");
            }
            if (!System.getProperty("jazzer.coverage_dump", "").isEmpty()) {
                Log.warn("--coverage_dump does not support parallel fuzzing and has been disabled");
                System.clearProperty("jazzer.coverage_dump");
            }
            if ((idSyncFileArg = System.getProperty("jazzer.id_sync_file", "")).isEmpty()) {
                idSyncFile = Files.createTempFile("jazzer-", "", new FileAttribute[0]);
                args2.add("--id_sync_file=" + idSyncFile.toAbsolutePath());
            } else {
                idSyncFile = Files.write(Paths.get(idSyncFileArg, new String[0]), new byte[0], new OpenOption[0]);
            }
            idSyncFile.toFile().deleteOnExit();
        }
        if (args2.stream().anyMatch("-merge_inner=1"::equals)) {
            System.setProperty("jazzer.internal.merge_inner", "true");
        }
        if ((seed = (String)args2.stream().reduce(null, (prev, cur) -> cur.startsWith("-seed=") ? cur.substring("-seed=".length()) : prev)) == null) {
            seed = Integer.toUnsignedString(new SecureRandom().nextInt());
            if (!spawnsSubprocesses) {
                args2.add("-seed=" + seed);
            }
        }
        System.setProperty("jazzer.internal.seed", seed);
        if (args2.stream().noneMatch(arg -> arg.startsWith("-rss_limit_mb="))) {
            args2.add(Driver.getDefaultRssLimitMbArg());
        }
        AgentInstaller.install(Opt.hooks);
        Driver.class.getClassLoader().setDefaultAssertionStatus(true);
        if (!Opt.autofuzz.isEmpty()) {
            FuzzTargetHolder.fuzzTarget = FuzzTargetHolder.AUTOFUZZ_FUZZ_TARGET;
            return FuzzTargetRunner.startLibFuzzer(args2);
        }
        String targetClassName = FuzzTargetFinder.findFuzzTargetClassName();
        if (targetClassName == null) {
            Log.error("Missing argument --target_class=<fuzz_target_class>");
            System.exit(1);
        }
        if (JUnitRunner.isSupported() && (runner = JUnitRunner.create(targetClassName, args2)).isPresent()) {
            return runner.get().run();
        }
        FuzzTargetHolder.fuzzTarget = FuzzTargetFinder.findFuzzTarget(targetClassName);
        return FuzzTargetRunner.startLibFuzzer(args2);
    }

    private static String getDefaultRssLimitMbArg() {
        long maxHeapInBytes = Runtime.getRuntime().maxMemory();
        return "-rss_limit_mb=" + (2L * maxHeapInBytes / 0x100000L + 1024L);
    }
}

