/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.driver.FuzzTargetHolder;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.utils.Log;
import com.code_intelligence.jazzer.utils.ManifestUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;

class FuzzTargetFinder {
    private static final String FUZZER_TEST_ONE_INPUT = "fuzzerTestOneInput";
    private static final String FUZZER_INITIALIZE = "fuzzerInitialize";
    private static final String FUZZER_TEAR_DOWN = "fuzzerTearDown";

    FuzzTargetFinder() {
    }

    static String findFuzzTargetClassName() {
        if (!Opt.targetClass.isEmpty()) {
            return Opt.targetClass;
        }
        return ManifestUtils.detectFuzzTargetClass();
    }

    static FuzzTargetHolder.FuzzTarget findFuzzTarget(String targetClassName) {
        Class<?> fuzzTargetClass;
        try {
            fuzzTargetClass = Class.forName(targetClassName);
        }
        catch (ClassNotFoundException e) {
            Log.error(String.format("'%s' not found on classpath:%n%n%s%n%nAll required classes must be on the classpath specified via --cp.", targetClassName, System.getProperty("java.class.path")));
            System.exit(1);
            throw new IllegalStateException("Not reached");
        }
        return FuzzTargetFinder.findFuzzTargetByMethodName(fuzzTargetClass);
    }

    private static FuzzTargetHolder.FuzzTarget findFuzzTargetByMethodName(Class<?> clazz) {
        Optional<Method> bytesFuzzTarget = FuzzTargetFinder.targetPublicStaticMethod(clazz, FUZZER_TEST_ONE_INPUT, byte[].class);
        Optional<Method> dataFuzzTarget = FuzzTargetFinder.targetPublicStaticMethod(clazz, FUZZER_TEST_ONE_INPUT, FuzzedDataProvider.class);
        if (bytesFuzzTarget.isPresent() == dataFuzzTarget.isPresent()) {
            throw new IllegalArgumentException(String.format("%s must define exactly one of the following two functions:%npublic static void fuzzerTestOneInput(byte[] ...)%npublic static void fuzzerTestOneInput(FuzzedDataProvider ...)%nNote: Fuzz targets returning boolean are no longer supported; exceptions should be thrown instead of returning true.", clazz.getName()));
        }
        Callable<Object> initialize2 = Stream.of(FuzzTargetFinder.targetPublicStaticMethod(clazz, FUZZER_INITIALIZE, String[].class).map(init -> () -> {
            init.invoke(null, new Object[]{Opt.targetArgs.toArray(new String[0])});
            return null;
        }), FuzzTargetFinder.targetPublicStaticMethod(clazz, FUZZER_INITIALIZE, new Class[0]).map(init -> () -> {
            init.invoke(null, new Object[0]);
            return null;
        })).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(() -> null);
        return new FuzzTargetHolder.FuzzTarget(dataFuzzTarget.orElseGet(bytesFuzzTarget::get), initialize2, FuzzTargetFinder.targetPublicStaticMethod(clazz, FUZZER_TEAR_DOWN, new Class[0]));
    }

    private static Optional<Method> targetPublicStaticMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) {
                return Optional.empty();
            }
            return Optional.of(method);
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }
}

