/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.autofuzz.FuzzTarget;
import com.code_intelligence.jazzer.driver.ExceptionUtils;
import com.code_intelligence.jazzer.driver.FuzzTargetHolder;
import com.code_intelligence.jazzer.driver.FuzzedDataProviderImpl;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.driver.RecordingFuzzedDataProvider;
import com.code_intelligence.jazzer.driver.ReproducerTemplate;
import com.code_intelligence.jazzer.driver.SignalHandler;
import com.code_intelligence.jazzer.instrumentor.CoverageRecorder;
import com.code_intelligence.jazzer.runtime.FuzzTargetRunnerNatives;
import com.code_intelligence.jazzer.runtime.JazzerInternal;
import com.code_intelligence.jazzer.utils.Log;
import com.code_intelligence.jazzer.utils.UnsafeProvider;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.misc.Unsafe;

public final class FuzzTargetRunner {
    private static final String OPENTEST4J_TEST_ABORTED_EXCEPTION = "org.opentest4j.TestAbortedException";
    private static final Unsafe UNSAFE = UnsafeProvider.getUnsafe();
    private static final long BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final int LIBFUZZER_CONTINUE = 0;
    private static final int LIBFUZZER_RETURN_FROM_DRIVER = -2;
    private static final Set<Long> ignoredTokens = new HashSet<Long>(Opt.ignore);
    private static final FuzzedDataProviderImpl fuzzedDataProvider = FuzzedDataProviderImpl.withNativeData();
    private static final MethodHandle fuzzTargetMethod;
    private static final boolean useFuzzedDataProvider;
    private static final Object fuzzTargetInstance;
    private static final Method fuzzerTearDown;
    private static final ReproducerTemplate reproducerTemplate;
    private static Predicate<Throwable> findingHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int runOne(byte[] data2) {
        long dataPtr = UNSAFE.allocateMemory(data2.length);
        UNSAFE.copyMemory(data2, BYTE_ARRAY_OFFSET, null, dataPtr, data2.length);
        try {
            int n = FuzzTargetRunner.runOne(dataPtr, data2.length);
            return n;
        }
        finally {
            UNSAFE.freeMemory(dataPtr);
        }
    }

    private static int runOne(long dataPtr, int dataLength) {
        long dedupToken;
        Object argument;
        byte[] data2;
        Throwable finding = null;
        if (useFuzzedDataProvider) {
            fuzzedDataProvider.setNativeData(dataPtr, dataLength);
            data2 = null;
            argument = fuzzedDataProvider;
        } else {
            argument = data2 = FuzzTargetRunner.copyToArray(dataPtr, dataLength);
        }
        try {
            if (fuzzTargetInstance == null) {
                fuzzTargetMethod.invoke(argument);
            } else {
                fuzzTargetMethod.invoke(fuzzTargetInstance, argument);
            }
        }
        catch (Throwable uncaughtFinding) {
            finding = uncaughtFinding;
        }
        if (Opt.mergeInner) {
            return 0;
        }
        if (JazzerInternal.lastFinding != null) {
            finding = JazzerInternal.lastFinding;
            JazzerInternal.lastFinding = null;
        }
        if (finding == null || finding.getClass().getName().equals(OPENTEST4J_TEST_ABORTED_EXCEPTION)) {
            return 0;
        }
        if (Opt.hooks) {
            finding = ExceptionUtils.preprocessThrowable(finding);
        }
        long l = dedupToken = Opt.dedup ? ExceptionUtils.computeDedupToken(finding) : 0L;
        if (Opt.dedup && !ignoredTokens.add(dedupToken)) {
            return 0;
        }
        if (findingHandler != null) {
            FuzzTargetRunner.printCrashingInput();
            if (findingHandler.test(finding)) {
                return 0;
            }
            return -2;
        }
        FuzzTargetRunner.temporarilyDisableLibfuzzerExitHook();
        Log.finding(finding);
        if (Opt.dedup) {
            Log.structuredOutput(String.format(Locale.ROOT, "DEDUP_TOKEN: %016x", dedupToken));
        }
        Log.println("== libFuzzer crashing input ==");
        FuzzTargetRunner.printCrashingInput();
        if (fuzzTargetInstance == null) {
            FuzzTargetRunner.dumpReproducer(data2);
        }
        if (!Opt.dedup || Long.compareUnsigned(ignoredTokens.size(), Opt.keepGoing) >= 0) {
            if (!Opt.autofuzz.isEmpty() && Opt.dedup) {
                Log.println("");
                Log.info(String.format("To continue fuzzing past this particular finding, rerun with the following additional argument:%n%n    --ignore=%s%n%nTo ignore all findings of this kind, rerun with the following additional argument:%n%n    --autofuzz_ignore=%s", ignoredTokens.stream().map(token -> Long.toUnsignedString(token, 16)).collect(Collectors.joining(",")), Stream.concat(Opt.autofuzzIgnore.stream(), Stream.of(finding.getClass().getName())).collect(Collectors.joining(","))));
            }
            System.exit(77);
            throw new IllegalStateException("Not reached");
        }
        return 0;
    }

    public static int startLibFuzzer(List<String> args2) {
        SignalHandler.initialize();
        return FuzzTargetRunner.startLibFuzzer((byte[][])args2.stream().map(str -> str.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]));
    }

    public static void registerFindingHandler(Predicate<Throwable> findingHandler) {
        FuzzTargetRunner.findingHandler = findingHandler;
    }

    private static void shutdown() {
        if (!Opt.coverageDump.isEmpty() || !Opt.coverageReport.isEmpty()) {
            if (!Opt.coverageDump.isEmpty()) {
                CoverageRecorder.dumpJacocoCoverage(Opt.coverageDump);
            }
            if (!Opt.coverageReport.isEmpty()) {
                CoverageRecorder.dumpCoverageReport(Opt.coverageReport);
            }
        }
        if (fuzzerTearDown == null) {
            return;
        }
        Log.info("calling fuzzerTearDown function");
        try {
            fuzzerTearDown.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Log.finding(e.getCause());
            System.exit(77);
        }
        catch (Throwable t) {
            Log.error(t);
            System.exit(1);
        }
    }

    private static void dumpReproducer(byte[] data2) {
        String base64Data;
        MessageDigest digest;
        if (data2 == null) {
            assert (useFuzzedDataProvider);
            fuzzedDataProvider.reset();
            data2 = fuzzedDataProvider.consumeRemainingAsBytes();
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 not available", e);
        }
        String dataSha1 = FuzzTargetRunner.toHexString(digest.digest(data2));
        if (!Opt.autofuzz.isEmpty()) {
            fuzzedDataProvider.reset();
            FuzzTarget.dumpReproducer(fuzzedDataProvider, Opt.reproducerPath, dataSha1);
            return;
        }
        if (useFuzzedDataProvider) {
            fuzzedDataProvider.reset();
            FuzzedDataProvider recordingFuzzedDataProvider = RecordingFuzzedDataProvider.makeFuzzedDataProviderProxy(fuzzedDataProvider);
            try {
                fuzzTargetMethod.invokeExact(recordingFuzzedDataProvider);
                if (JazzerInternal.lastFinding == null) {
                    Log.warn("Failed to reproduce crash when rerunning with recorder");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                base64Data = RecordingFuzzedDataProvider.serializeFuzzedDataProviderProxy(recordingFuzzedDataProvider);
            }
            catch (IOException e) {
                Log.error("Failed to create reproducer", e);
                System.exit(1);
                throw new IllegalStateException("Not reached");
            }
        }
        base64Data = Base64.getEncoder().encodeToString(data2);
        reproducerTemplate.dumpReproducer(base64Data, dataSha1);
    }

    private static String toHexString(byte[] bytes) {
        String unpadded = new BigInteger(1, bytes).toString(16);
        int numLeadingZeroes = 2 * bytes.length - unpadded.length();
        return String.join((CharSequence)"", Collections.nCopies(numLeadingZeroes, "0")) + unpadded;
    }

    private static void dumpAllStackTraces() {
        ExceptionUtils.dumpAllStackTraces();
    }

    private static byte[] copyToArray(long ptr, int length) {
        byte[] array = new byte[length];
        UNSAFE.copyMemory(null, ptr, array, BYTE_ARRAY_OFFSET, length);
        return array;
    }

    private static int startLibFuzzer(byte[][] args2) {
        return FuzzTargetRunnerNatives.startLibFuzzer((byte[][])args2, FuzzTargetRunner.class);
    }

    public static void printCrashingInput() {
        FuzzTargetRunnerNatives.printCrashingInput();
    }

    private static void temporarilyDisableLibfuzzerExitHook() {
        FuzzTargetRunnerNatives.temporarilyDisableLibfuzzerExitHook();
    }

    static {
        FuzzTargetHolder.FuzzTarget fuzzTarget = FuzzTargetHolder.fuzzTarget;
        Class<?> fuzzTargetClass = fuzzTarget.method.getDeclaringClass();
        fuzzTarget.method.setAccessible(true);
        try {
            fuzzTargetMethod = MethodHandles.lookup().unreflect(fuzzTarget.method);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        useFuzzedDataProvider = fuzzTarget.usesFuzzedDataProvider();
        fuzzerTearDown = fuzzTarget.tearDown.orElse(null);
        reproducerTemplate = new ReproducerTemplate(fuzzTargetClass.getName(), useFuzzedDataProvider);
        JazzerInternal.onFuzzTargetReady((String)fuzzTargetClass.getName());
        try {
            fuzzTargetInstance = fuzzTarget.newInstance.call();
        }
        catch (Throwable t) {
            Log.finding(t);
            System.exit(1);
            throw new IllegalStateException("Not reached");
        }
        if (Opt.hooks) {
            CoverageRecorder.updateCoveredIdsWithCoverageMap();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(FuzzTargetRunner::shutdown));
    }
}

